/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.lang.protorules.PrimitiveExtractor;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class MultiSlotDualAssign
extends AssignAction {
    private StorageClass baseType;
    private StorageClass altType;
    private boolean isBigEndian;
    private boolean consumeFromStack;
    private boolean consumeMostSig;
    private boolean justifyRight;
    private boolean fillAlternate;
    private int tileSize;
    private ParamEntry[] baseTiles;
    private ParamEntry[] altTiles;
    private ParamEntry stackEntry;

    private void initializeEntries() throws InvalidInputException {
        this.baseTiles = this.resource.extractTiles(this.baseType);
        this.altTiles = this.resource.extractTiles(this.altType);
        this.stackEntry = this.resource.extractStack();
        if (this.baseTiles.length == 0 || this.altTiles.length == 0) {
            throw new InvalidInputException("Could not find matching resources for action: join_dual_class");
        }
        this.tileSize = this.baseTiles[0].getSize();
        if (this.tileSize != this.altTiles[0].getSize()) {
            throw new InvalidInputException("Storage class register sizes do not match for action: join_dual_class");
        }
        if (this.consumeFromStack && this.stackEntry == null) {
            throw new InvalidInputException("Cannot find matching stack resource for action: join_dual_class");
        }
    }

    private int getFirstUnused(int iter, ParamEntry[] tiles, int[] status) {
        while (iter != tiles.length) {
            ParamEntry entry = tiles[iter];
            if (status[entry.getGroup()] == 0) {
                return iter;
            }
            ++iter;
        }
        return tiles.length;
    }

    private int getTileClass(PrimitiveExtractor primitives, int off, int[] index) {
        int res = 1;
        int count = 0;
        int endBoundary = off + this.tileSize;
        if (index[0] >= primitives.size()) {
            return -1;
        }
        PrimitiveExtractor.Primitive firstPrimitive = primitives.get(index[0]);
        while (index[0] < primitives.size()) {
            PrimitiveExtractor.Primitive element = primitives.get(index[0]);
            if (element.offset < off) {
                return -1;
            }
            if (element.offset >= endBoundary) break;
            if (element.offset + element.dt.getLength() > endBoundary) {
                return -1;
            }
            ++count;
            index[0] = index[0] + 1;
            StorageClass storage = ParamEntry.getBasicTypeClass(element.dt);
            if (storage == this.altType) continue;
            res = 0;
        }
        if (count == 0) {
            return -1;
        }
        if (this.fillAlternate) {
            if (count > 1) {
                res = 0;
            }
            if (firstPrimitive.dt.getLength() != this.tileSize) {
                res = 0;
            }
        }
        return res;
    }

    protected MultiSlotDualAssign(ParamListStandard res) {
        super(res);
        this.isBigEndian = res.isBigEndian();
        this.baseType = StorageClass.GENERAL;
        this.altType = StorageClass.FLOAT;
        this.consumeFromStack = false;
        this.consumeMostSig = false;
        this.justifyRight = false;
        if (this.isBigEndian) {
            this.consumeMostSig = true;
            this.justifyRight = true;
        }
        this.fillAlternate = false;
        this.tileSize = 0;
        this.stackEntry = null;
    }

    public MultiSlotDualAssign(StorageClass baseStore, StorageClass altStore, boolean stack, boolean mostSig, boolean justRight, boolean fillAlt, ParamListStandard res) throws InvalidInputException {
        super(res);
        this.isBigEndian = res.isBigEndian();
        this.baseType = baseStore;
        this.altType = altStore;
        this.consumeFromStack = stack;
        this.consumeMostSig = mostSig;
        this.justifyRight = justRight;
        this.fillAlternate = fillAlt;
        this.stackEntry = null;
        this.initializeEntries();
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) throws InvalidInputException {
        return new MultiSlotDualAssign(this.baseType, this.altType, this.consumeFromStack, this.consumeMostSig, this.justifyRight, this.fillAlternate, newResource);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        int i;
        if (this.getClass() != op.getClass()) {
            return false;
        }
        MultiSlotDualAssign otherAction = (MultiSlotDualAssign)op;
        if (this.consumeFromStack != otherAction.consumeFromStack || this.consumeMostSig != otherAction.consumeMostSig || this.justifyRight != otherAction.justifyRight || this.fillAlternate != otherAction.fillAlternate) {
            return false;
        }
        if (this.baseType != otherAction.baseType || this.altType != otherAction.altType) {
            return false;
        }
        if (this.baseTiles.length != otherAction.baseTiles.length) {
            return false;
        }
        for (i = 0; i < this.baseTiles.length; ++i) {
            if (this.baseTiles[i].isEquivalent(otherAction.baseTiles[i])) continue;
            return false;
        }
        if (this.altTiles.length != otherAction.altTiles.length) {
            return false;
        }
        for (i = 0; i < this.altTiles.length; ++i) {
            if (this.altTiles[i].isEquivalent(otherAction.altTiles[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        int sizeLeft;
        int trialSize;
        PrimitiveExtractor primitives = new PrimitiveExtractor(dt, false, 0, 1024);
        if (!primitives.isValid() || primitives.size() == 0 || primitives.containsHoles()) {
            return 1;
        }
        ParameterPieces param = new ParameterPieces();
        int[] primitiveIndex = new int[]{0};
        int[] tmpStatus = (int[])status.clone();
        ArrayList<Varnode> pieces = new ArrayList<Varnode>();
        int typeSize = dt.getLength();
        int align = dt.getAlignment();
        int iterBase = 0;
        int iterAlt = 0;
        for (sizeLeft = typeSize; sizeLeft > 0; sizeLeft -= trialSize) {
            ParamEntry entry;
            int iterType = this.getTileClass(primitives, typeSize - sizeLeft, primitiveIndex);
            if (iterType < 0) {
                return 1;
            }
            if (iterType == 0) {
                if ((iterBase = this.getFirstUnused(iterBase, this.baseTiles, tmpStatus)) == this.baseTiles.length) {
                    if (this.consumeFromStack) break;
                    return 1;
                }
                entry = this.baseTiles[iterBase];
            } else {
                if ((iterAlt = this.getFirstUnused(iterAlt, this.altTiles, tmpStatus)) == this.altTiles.length) {
                    if (this.consumeFromStack) break;
                    return 1;
                }
                entry = this.altTiles[iterAlt];
            }
            trialSize = entry.getSize();
            entry.getAddrBySlot(tmpStatus[entry.getGroup()], trialSize, 1, param);
            tmpStatus[entry.getGroup()] = -1;
            Varnode vn = new Varnode(param.address, trialSize);
            pieces.add(vn);
        }
        if (sizeLeft > 0) {
            if (!this.consumeFromStack) {
                return 1;
            }
            int grp = this.stackEntry.getGroup();
            tmpStatus[grp] = this.stackEntry.getAddrBySlot(tmpStatus[grp], sizeLeft, align, param, this.justifyRight);
            if (param.address == null) {
                return 1;
            }
            Varnode vn = new Varnode(param.address, sizeLeft);
            pieces.add(vn);
        }
        if (sizeLeft < 0) {
            MultiSlotDualAssign.justifyPieces(pieces, -sizeLeft, this.isBigEndian, this.consumeMostSig, this.justifyRight);
        }
        System.arraycopy(tmpStatus, 0, status, 0, tmpStatus.length);
        res.type = dt;
        res.assignAddressFromPieces(pieces, this.consumeMostSig, false, this.resource.getLanguage());
        return 0;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_JOIN_DUAL_CLASS);
        if (this.resource.isBigEndian() != this.justifyRight) {
            encoder.writeBool(AttributeId.ATTRIB_REVERSEJUSTIFY, true);
        }
        if (this.resource.isBigEndian() != this.consumeMostSig) {
            encoder.writeBool(AttributeId.ATTRIB_REVERSESIGNIF, true);
        }
        if (this.baseType != StorageClass.GENERAL) {
            encoder.writeString(AttributeId.ATTRIB_STORAGE, this.baseType.toString());
        }
        if (this.altType != StorageClass.FLOAT) {
            encoder.writeString(AttributeId.ATTRIB_B, this.altType.toString());
        }
        encoder.writeBool(AttributeId.ATTRIB_STACKSPILL, this.consumeFromStack);
        encoder.writeBool(AttributeId.ATTRIB_FILL_ALTERNATE, this.fillAlternate);
        encoder.closeElement(ElementId.ELEM_JOIN);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_JOIN_DUAL_CLASS.name()});
        for (Map.Entry attrib : elem.getAttributes().entrySet()) {
            String name = (String)attrib.getKey();
            if (name.equals(AttributeId.ATTRIB_REVERSEJUSTIFY.name())) {
                if (!SpecXmlUtils.decodeBoolean((String)((String)attrib.getValue()))) continue;
                this.justifyRight = !this.justifyRight;
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_REVERSESIGNIF.name())) {
                if (!SpecXmlUtils.decodeBoolean((String)((String)attrib.getValue()))) continue;
                this.consumeMostSig = !this.consumeMostSig;
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_STORAGE.name()) || name.equals(AttributeId.ATTRIB_A.name())) {
                this.baseType = StorageClass.getClass((String)attrib.getValue());
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_B.name())) {
                this.altType = StorageClass.getClass((String)attrib.getValue());
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_STACKSPILL.name())) {
                this.consumeFromStack = SpecXmlUtils.decodeBoolean((String)((String)attrib.getValue()));
                continue;
            }
            if (!name.equals(AttributeId.ATTRIB_FILL_ALTERNATE.name())) continue;
            this.fillAlternate = SpecXmlUtils.decodeBoolean((String)((String)attrib.getValue()));
        }
        parser.end(elem);
        try {
            this.initializeEntries();
        }
        catch (InvalidInputException e) {
            throw new XmlParseException(e.getMessage());
        }
    }
}

