/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.external;

import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.database.symbol.MemorySymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class ExternalLocationDB
implements ExternalLocation {
    private ExternalManagerDB extMgr;
    private MemorySymbol symbol;

    ExternalLocationDB(ExternalManagerDB extMgr, MemorySymbol symbol) {
        this.extMgr = extMgr;
        this.symbol = symbol;
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public String getLibraryName() {
        Library library = this.getLibrary();
        return library != null ? library.getName() : "<UNKNOWN>";
    }

    private Library getLibrary() {
        Namespace parent;
        for (parent = this.symbol.getParentNamespace(); parent != null && !(parent instanceof Library); parent = parent.getParentNamespace()) {
        }
        return (Library)parent;
    }

    @Override
    public Namespace getParentNameSpace() {
        return this.symbol.getParentNamespace();
    }

    @Override
    public String getParentName() {
        return this.symbol.getParentNamespace().getName();
    }

    long getExtNameID() {
        return this.symbol.getParentNamespace().getID();
    }

    @Override
    public String getLabel() {
        return this.symbol.getName();
    }

    @Override
    public String getOriginalImportedName() {
        return this.symbol.getExternalOriginalImportedName();
    }

    @Override
    public SourceType getSource() {
        return this.symbol.getSource();
    }

    @Override
    public Address getAddress() {
        return this.symbol.getExternalProgramAddress();
    }

    @Override
    public Address getExternalSpaceAddress() {
        return this.symbol.getAddress();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.symbol.getName(true));
        if (this.getOriginalImportedName() != null) {
            builder.append(" (").append(this.getOriginalImportedName()).append(")");
        }
        return builder.toString();
    }

    @Override
    public boolean isFunction() {
        return this.symbol.getSymbolType() == SymbolType.FUNCTION;
    }

    @Override
    public DataType getDataType() {
        long dataTypeID = this.symbol.getDataTypeId();
        if (dataTypeID < 0L) {
            return null;
        }
        return this.extMgr.getProgram().getDataTypeManager().getDataType(dataTypeID);
    }

    @Override
    public void setDataType(DataType dt) {
        long dataTypeID = this.extMgr.getProgram().getDataTypeManager().getResolvedID(dt);
        this.symbol.setDataTypeId(dataTypeID);
    }

    @Override
    public Function getFunction() {
        if (this.symbol.getSymbolType() == SymbolType.FUNCTION) {
            return (Function)this.symbol.getObject();
        }
        return null;
    }

    @Override
    public Function createFunction() {
        if (this.symbol.getSymbolType() == SymbolType.FUNCTION) {
            return this.getFunction();
        }
        Function function = this.extMgr.createFunction(this);
        this.symbol = (FunctionSymbol)function.getSymbol();
        return function;
    }

    void setLabel(String label, SourceType source) throws InvalidInputException {
        if (label == null) {
            this.setName(this.getLibrary(), null, SourceType.DEFAULT);
        } else if (label.indexOf("::") < 0) {
            this.setName(this.symbol.getParentNamespace(), label, source);
        } else {
            SymbolPath symbolPath = new SymbolPath(label);
            Namespace namespace = NamespaceUtils.createNamespaceHierarchy(symbolPath.getParentPath(), this.getLibrary(), this.extMgr.getProgram(), source);
            this.setName(namespace, symbolPath.getName(), source);
        }
    }

    @Override
    public void setLocation(String label, Address addr, SourceType source) throws InvalidInputException {
        if (label != null && label.length() == 0) {
            label = null;
        }
        if (label == null && addr == null) {
            throw new InvalidInputException("Either an external label or address is required");
        }
        if (addr != null && !addr.isMemoryAddress()) {
            throw new InvalidInputException("Invalid memory address");
        }
        this.setLabel(label, source);
        this.setAddress(addr);
    }

    @Override
    public void setAddress(Address address) throws InvalidInputException {
        if (address == null && this.getSource() == SourceType.DEFAULT) {
            throw new InvalidInputException("Either an external label or address is required");
        }
        this.symbol.setExternalProgramAddress(address, true);
    }

    public void saveOriginalNameIfNeeded(Namespace oldNamespace, String oldName, SourceType oldSource) {
        boolean wasInLibrary = oldNamespace instanceof Library;
        String originalImportedName = this.getOriginalImportedName();
        if (this.getLabel().equals(originalImportedName)) {
            this.symbol.setExternalOriginalImportedName(null, false);
        } else if (wasInLibrary && this.getSource() != SourceType.DEFAULT && oldSource == SourceType.IMPORTED && originalImportedName == null) {
            this.symbol.setExternalOriginalImportedName(oldName, false);
        }
    }

    @Override
    public void setName(Namespace namespace, String newName, SourceType sourceType) throws InvalidInputException {
        try {
            if (!namespace.isExternal()) {
                throw new IllegalArgumentException("external namespace required");
            }
            if (newName == null || newName.length() == 0) {
                sourceType = SourceType.DEFAULT;
                String originalName = this.getOriginalImportedName();
                if (originalName != null) {
                    newName = originalName;
                    namespace = NamespaceUtils.getLibrary(namespace);
                    sourceType = SourceType.IMPORTED;
                } else if (this.getAddress() == null) {
                    throw new InvalidInputException("Either an external label or address is required");
                }
            } else if (namespace instanceof Library && newName.equals(this.getOriginalImportedName())) {
                sourceType = SourceType.IMPORTED;
            }
            this.symbol.setNameAndNamespace(newName, namespace, sourceType);
        }
        catch (CircularDependencyException | DuplicateNameException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
    }

    @Override
    public void restoreOriginalName() {
        String originalName = this.getOriginalImportedName();
        if (originalName == null) {
            return;
        }
        try {
            Library library = NamespaceUtils.getLibrary(this.symbol.getParentNamespace());
            this.symbol.setExternalOriginalImportedName(null, false);
            this.symbol.setNameAndNamespace(originalName, library, SourceType.IMPORTED);
        }
        catch (CircularDependencyException | DuplicateNameException | InvalidInputException e) {
            throw new AssertException("Can't happen here", (Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalLocationDB other = (ExternalLocationDB)obj;
        return this.symbol.equals(other.symbol);
    }

    @Override
    public boolean isEquivalent(ExternalLocation other) {
        if (other == null) {
            return false;
        }
        if (this.isFunction() != other.isFunction()) {
            return false;
        }
        String name = this.getLabel();
        String originalImportName = this.getOriginalImportedName();
        String otherName = other.getLabel();
        String otherOriginalImportName = other.getOriginalImportedName();
        if (originalImportName != null && originalImportName.equals(otherOriginalImportName)) {
            return true;
        }
        if (otherName.equals(originalImportName)) {
            return true;
        }
        if (name.equals(otherOriginalImportName)) {
            return true;
        }
        if (originalImportName != null || otherOriginalImportName != null) {
            return false;
        }
        if (!this.getSymbol().getName(true).equals(other.getSymbol().getName(true))) {
            return false;
        }
        return SystemUtilities.isEqual((Object)this.getAddress(), (Object)other.getAddress());
    }
}

