/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr.match;

import ghidra.app.plugin.assembler.sleigh.expr.match.AbstractExpressionMatcher;
import ghidra.app.plugin.assembler.sleigh.expr.match.ExpressionMatcher;
import ghidra.app.plugin.processors.sleigh.expression.BinaryExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BinaryExpressionMatcher<T extends BinaryExpression>
extends AbstractExpressionMatcher<T> {
    protected final ExpressionMatcher<?> leftMatcher;
    protected final ExpressionMatcher<?> rightMatcher;

    public BinaryExpressionMatcher(Set<Class<? extends T>> ops, ExpressionMatcher<?> leftMatcher, ExpressionMatcher<?> rightMatcher) {
        super(ops);
        this.leftMatcher = leftMatcher;
        this.rightMatcher = rightMatcher;
    }

    public BinaryExpressionMatcher(Class<T> cls, ExpressionMatcher<?> leftMatcher, ExpressionMatcher<?> rightMatcher) {
        super(cls);
        this.leftMatcher = leftMatcher;
        this.rightMatcher = rightMatcher;
    }

    @Override
    protected boolean matchDetails(T expression, Map<ExpressionMatcher<?>, PatternExpression> result) {
        return this.leftMatcher.match(((BinaryExpression)expression).getLeft(), result) && this.rightMatcher.match(((BinaryExpression)expression).getRight(), result);
    }

    public static class Commutative<T extends BinaryExpression>
    extends BinaryExpressionMatcher<T> {
        public Commutative(Set<Class<? extends T>> ops, ExpressionMatcher<?> leftMatcher, ExpressionMatcher<?> rightMatcher) {
            super(ops, leftMatcher, rightMatcher);
        }

        public Commutative(Class<T> cls, ExpressionMatcher<?> leftMatcher, ExpressionMatcher<?> rightMatcher) {
            super(cls, leftMatcher, rightMatcher);
        }

        @Override
        protected boolean matchDetails(T expression, Map<ExpressionMatcher<?>, PatternExpression> result) {
            HashSet reset = new HashSet(result.keySet());
            if (this.leftMatcher.match(((BinaryExpression)expression).getLeft(), result) && this.rightMatcher.match(((BinaryExpression)expression).getRight(), result)) {
                return true;
            }
            result.keySet().retainAll(reset);
            return this.rightMatcher.match(((BinaryExpression)expression).getLeft(), result) && this.leftMatcher.match(((BinaryExpression)expression).getRight(), result);
        }
    }
}

