/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeExecutorStateSpace;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemBufferMixin;
import ghidra.program.model.mem.Memory;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractBytesPcodeExecutorStatePiece<S extends BytesPcodeExecutorStateSpace>
extends AbstractLongOffsetPcodeExecutorStatePiece<byte[], byte[], S> {
    protected final Map<AddressSpace, S> spaceMap = new HashMap<AddressSpace, S>();

    public AbstractBytesPcodeExecutorStatePiece(Language language, PcodeArithmetic<byte[]> arithmetic, PcodeStateCallbacks cb) {
        super(language, arithmetic, arithmetic, cb);
    }

    public AbstractBytesPcodeExecutorStatePiece(Language language, PcodeStateCallbacks cb) {
        this(language, BytesPcodeArithmetic.forLanguage(language), cb);
    }

    protected abstract S newSpace(AddressSpace var1);

    @Override
    protected S getForSpace(AddressSpace space, boolean toWrite) {
        if (toWrite) {
            return (S)this.spaceMap.computeIfAbsent(space, this::newSpace);
        }
        return (S)((BytesPcodeExecutorStateSpace)this.spaceMap.get(space));
    }

    @Override
    protected void setInSpace(S space, long offset, int size, byte[] val, PcodeStateCallbacks cb) {
        ((BytesPcodeExecutorStateSpace)space).write(offset, val, 0, size, cb);
    }

    @Override
    protected byte[] getFromSpace(S space, long offset, int size, PcodeExecutorStatePiece.Reason reason, PcodeStateCallbacks cb) {
        byte[] read = ((BytesPcodeExecutorStateSpace)space).read(offset, size, reason, cb);
        if (read.length != size) {
            throw new AccessPcodeExecutionException("Incomplete read (" + read.length + " of " + size + " bytes)");
        }
        return read;
    }

    @Override
    protected Map<Register, byte[]> getRegisterValuesFromSpace(S s, List<Register> registers) {
        return ((BytesPcodeExecutorStateSpace)s).getRegisterValues(registers);
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        return new StateMemBuffer(address, (BytesPcodeExecutorStateSpace)this.getForSpace(address.getAddressSpace(), false), purpose.reason());
    }

    @Override
    public void clear() {
        for (BytesPcodeExecutorStateSpace space : this.spaceMap.values()) {
            space.clear();
        }
    }

    protected class StateMemBuffer
    implements MemBufferMixin {
        protected final Address address;
        protected BytesPcodeExecutorStateSpace source;
        protected final PcodeExecutorStatePiece.Reason reason;

        public StateMemBuffer(Address address, BytesPcodeExecutorStateSpace source, PcodeExecutorStatePiece.Reason reason) {
            this.address = address;
            this.source = source;
            this.reason = reason;
        }

        public Address getAddress() {
            return this.address;
        }

        public Memory getMemory() {
            return null;
        }

        public boolean isBigEndian() {
            return AbstractBytesPcodeExecutorStatePiece.this.language.isBigEndian();
        }

        public int getBytes(ByteBuffer buffer, int addressOffset) {
            if (this.source == null) {
                Address min = this.address.add((long)addressOffset);
                AddressSet set = new AddressSet(min, min.add((long)(buffer.remaining() - 1)));
                if (set.equals((Object)AbstractBytesPcodeExecutorStatePiece.this.cb.readUninitialized(AbstractBytesPcodeExecutorStatePiece.this, (AddressSetView)set))) {
                    return 0;
                }
                this.source = AbstractBytesPcodeExecutorStatePiece.this.getForSpace(this.address.getAddressSpace(), false);
                if (this.source == null) {
                    return 0;
                }
            }
            byte[] data = this.source.read(this.address.getOffset() + (long)addressOffset, buffer.remaining(), this.reason, AbstractBytesPcodeExecutorStatePiece.this.cb);
            buffer.put(data);
            return data.length;
        }
    }
}

