/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb.PdbBitField;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBitfieldMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsDataTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.util.exception.CancelledException;

public class BitfieldTypeApplier
extends MsDataTypeApplier {
    public BitfieldTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    @Override
    boolean apply(AbstractMsType type) throws PdbException, CancelledException {
        Pdb2BitField bitFieldDataType;
        AbstractBitfieldMsType mType = (AbstractBitfieldMsType)type;
        RecordNumber elementRecordNumber = mType.getElementRecordNumber();
        DataType baseDataType = this.applicator.getDataTypeOrSchedule(elementRecordNumber);
        if (baseDataType == null) {
            return false;
        }
        try {
            bitFieldDataType = new Pdb2BitField(this, baseDataType.clone(this.applicator.getDataTypeManager()), mType.getBitLength(), mType.getBitPosition());
        }
        catch (InvalidDataTypeException e) {
            throw new PdbException("Problem creating PdbBitField for " + type.getName() + ", error: " + e.toString());
        }
        this.applicator.putDataType(mType, (DataType)bitFieldDataType);
        return true;
    }

    private class Pdb2BitField
    extends PdbBitField {
        private Pdb2BitField(BitfieldTypeApplier bitfieldTypeApplier, DataType baseDataType, int bitSize, int bitOffsetWithinBaseType) throws InvalidDataTypeException {
            super(baseDataType, bitSize, bitOffsetWithinBaseType);
        }
    }
}

