/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolRecords;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.util.exception.CancelledException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MsSymbolIterator
implements Iterator<AbstractMsSymbol> {
    private int streamNumber;
    private int startOffset;
    private SymbolRecords symbolRecords;
    private int lengthSymbols;
    private int nextRetrieveOffset;
    private int currentOffset;
    private SymbolRecords.SymLen symLen;

    public MsSymbolIterator(AbstractPdb pdb, int streamNumber, int startOffset, int lengthSymbols) {
        this.streamNumber = streamNumber;
        this.startOffset = startOffset;
        this.lengthSymbols = lengthSymbols;
        this.symbolRecords = pdb.getDebugInfo().getSymbolRecords();
        if (streamNumber == 65535) {
            this.symLen = null;
            this.nextRetrieveOffset = 0;
            this.currentOffset = 0;
        } else {
            this.initGet();
        }
    }

    @Override
    public boolean hasNext() {
        return this.symLen != null;
    }

    public AbstractMsSymbol peek() throws NoSuchElementException {
        if (this.symLen == null) {
            throw new NoSuchElementException();
        }
        return this.symLen.symbol();
    }

    @Override
    public AbstractMsSymbol next() {
        if (this.symLen == null) {
            throw new NoSuchElementException();
        }
        SymbolRecords.SymLen offer = this.symLen;
        this.currentOffset = this.nextRetrieveOffset;
        this.symLen = this.retrieveRecord();
        return offer.symbol();
    }

    private SymbolRecords.SymLen retrieveRecord() {
        if (this.streamNumber == 65535) {
            return null;
        }
        if (this.nextRetrieveOffset >= this.lengthSymbols) {
            return null;
        }
        try {
            SymbolRecords.SymLen retrieved = this.symbolRecords.getRandomAccessRecord(this.streamNumber, this.nextRetrieveOffset);
            if (retrieved != null) {
                this.nextRetrieveOffset += retrieved.length();
            }
            return retrieved;
        }
        catch (PdbException | CancelledException e) {
            return null;
        }
    }

    public long getCurrentOffset() {
        return this.currentOffset;
    }

    public void initGet() {
        if (this.streamNumber == 65535) {
            return;
        }
        this.currentOffset = this.nextRetrieveOffset = this.startOffset;
        this.symLen = this.retrieveRecord();
    }

    public void initGetByOffset(long offset) {
        Long l = offset;
        this.currentOffset = this.nextRetrieveOffset = l.intValue();
        this.symLen = this.retrieveRecord();
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }
}

