/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13ChecksumType;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.NumericUtilities;

public class C13FileChecksum {
    private long offsetFilename;
    private int length;
    private int checksumTypeValue;
    private byte[] bytes;

    static int getBaseRecordSize() {
        return 6;
    }

    C13FileChecksum(PdbByteReader reader) throws PdbException {
        this.offsetFilename = reader.parseUnsignedIntVal();
        this.length = reader.parseUnsignedByteVal();
        this.checksumTypeValue = reader.parseUnsignedByteVal();
        this.bytes = reader.parseBytes(this.length);
        reader.align4();
    }

    public long getOffsetFilename() {
        return this.offsetFilename;
    }

    public long getLength() {
        return this.length;
    }

    public int getChecksumTypeValue() {
        return this.checksumTypeValue;
    }

    public byte[] getChecksumBytes() {
        return this.bytes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("0x%08x, 0x%02x %s(%02x): ", new Object[]{this.offsetFilename, this.length, C13ChecksumType.fromValue(this.checksumTypeValue), this.checksumTypeValue}));
        builder.append(NumericUtilities.convertBytesToString((byte[])this.bytes));
        return builder.toString();
    }
}

