/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.DataToStringConverter;
import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.list.GListCellRenderer;
import ghidra.util.datastruct.CaseInsensitiveDuplicateStringComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.UnsupportedOperationException;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;

public class DefaultDropDownSelectionDataModel<T>
implements DropDownTextFieldDataModel<T> {
    private static final char END_CHAR = '\uffff';
    protected List<T> data;
    protected Comparator<Object> comparator;
    private DataToStringConverter<T> searchConverter;
    private DataToStringConverter<T> descriptionConverter;
    private ListCellRenderer<T> renderer = GListCellRenderer.createDefaultTextRenderer(value -> this.searchConverter.getString(value));

    public static DefaultDropDownSelectionDataModel<String> getStringModel(List<String> strings) {
        return new DefaultDropDownSelectionDataModel<String>(strings, DataToStringConverter.stringDataToStringConverter);
    }

    public DefaultDropDownSelectionDataModel(List<T> data, DataToStringConverter<T> searchConverter) {
        this(data, searchConverter, null);
    }

    public DefaultDropDownSelectionDataModel(List<T> data, DataToStringConverter<T> searchConverter, DataToStringConverter<T> descriptionConverter) {
        this.data = data;
        this.searchConverter = searchConverter;
        this.descriptionConverter = descriptionConverter != null ? descriptionConverter : searchConverter;
        this.comparator = new ObjectStringComparator();
        Collections.sort(data, this.comparator);
    }

    @Override
    public List<DropDownTextFieldDataModel.SearchMode> getSupportedSearchModes() {
        return List.of(DropDownTextFieldDataModel.SearchMode.STARTS_WITH, DropDownTextFieldDataModel.SearchMode.CONTAINS, DropDownTextFieldDataModel.SearchMode.WILDCARD);
    }

    @Override
    public List<T> getMatchingData(String searchText) {
        throw new UnsupportedOperationException("Method no longer supported.  Instead, call getMatchingData(String, SearchMode)");
    }

    @Override
    public List<T> getMatchingData(String searchText, DropDownTextFieldDataModel.SearchMode mode) {
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return new ArrayList<T>(this.data);
        }
        if (!this.getSupportedSearchModes().contains((Object)mode)) {
            throw new IllegalArgumentException("Unsupported SearchMode: " + String.valueOf((Object)mode));
        }
        if (mode == DropDownTextFieldDataModel.SearchMode.STARTS_WITH) {
            return this.getMatchingDataStartsWith(searchText);
        }
        Pattern p = mode.createPattern(searchText);
        return this.getMatchingDataRegex(p);
    }

    private List<T> getMatchingDataRegex(Pattern p) {
        ArrayList<T> results = new ArrayList<T>();
        for (T t : this.data) {
            String string = this.searchConverter.getString(t);
            Matcher m = p.matcher(string);
            if (!m.matches()) continue;
            results.add(t);
        }
        return results;
    }

    private List<T> getMatchingDataStartsWith(String searchText) {
        List<T> l = this.data;
        int startIndex = Collections.binarySearch(l, searchText, this.comparator);
        int endIndex = Collections.binarySearch(l, searchText + "\uffff", this.comparator);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (endIndex < 0) {
            endIndex = -endIndex - 1;
        }
        return this.data.subList(startIndex, endIndex);
    }

    @Override
    public int getIndexOfFirstMatchingEntry(List<T> list, String text) {
        int lastPreferredMatchIndex = -1;
        int i = 0;
        while (i < list.size()) {
            T t = list.get(i);
            String asString = this.searchConverter.getString(t);
            if (asString.equals(text)) {
                return i;
            }
            if (!asString.equalsIgnoreCase(text)) {
                return lastPreferredMatchIndex;
            }
            lastPreferredMatchIndex = i++;
        }
        return -1;
    }

    @Override
    public ListCellRenderer<T> getListRenderer() {
        return this.renderer;
    }

    @Override
    public String getDescription(T value) {
        return this.descriptionConverter.getString(value);
    }

    @Override
    public String getDisplayText(T value) {
        return this.searchConverter.getString(value);
    }

    private class ObjectStringComparator
    implements Comparator<Object> {
        Comparator<String> stringComparator = new CaseInsensitiveDuplicateStringComparator();

        private ObjectStringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = this.getString(o1);
            String s2 = this.getString(o2);
            return this.stringComparator.compare(s1, s2);
        }

        private String getString(Object obj) {
            if (obj instanceof String) {
                return (String)obj;
            }
            return DefaultDropDownSelectionDataModel.this.searchConverter.getString(obj);
        }
    }
}

