/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import docking.widgets.table.GTableCellRenderer;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.table.column.AbstractWrapperTypeColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.ProgramBasedDynamicTableColumnExtensionPoint;

public class FunctionBodySizeTableColumn
extends ProgramBasedDynamicTableColumnExtensionPoint<Function, Integer> {
    private FunctionBodySizeRenderer renderer = new FunctionBodySizeRenderer();

    public String getColumnName() {
        return "Function Size";
    }

    public Integer getValue(Function rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        return (int)rowObject.getBody().getNumAddresses();
    }

    public GColumnRenderer<Integer> getColumnRenderer() {
        return this.renderer;
    }

    private class FunctionBodySizeRenderer
    extends GTableCellRenderer
    implements AbstractWrapperTypeColumnRenderer<Integer> {
        private FunctionBodySizeRenderer() {
        }
    }
}

