/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.OpenWithTarget;
import ghidra.plugins.importer.batch.BatchImportDialog;
import java.util.List;

public class BatchImportFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder("FSB Import Batch", this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getSelectedCount() > 0).popupMenuIcon(FSBIcons.IMPORT).popupMenuPath(new String[]{"Batch Import"}).popupMenuGroup("F", "B").onAction(ac -> {
            List<FSRL> files = ac.getFSRLs(true);
            if (files.isEmpty()) {
                return;
            }
            boolean allDirs = ac.isSelectedAllDirs();
            if (files.size() > 1 && !allDirs) {
                files = ac.getFileFSRLs();
            }
            PluginTool tool = this.context.plugin().getTool();
            OpenWithTarget openWith = OpenWithTarget.getDefault(tool);
            BatchImportDialog.showAndImport(tool, null, files, null, openWith.getPm());
        }).build());
    }
}

