/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.app.services.DataTypeManagerService;
import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.Map;

public class UpdateEnumCommentQuickFix
extends QuickFix {
    private Enum enumm;
    private String valueName;

    public UpdateEnumCommentQuickFix(Program program, Enum enumDt, String valueName, String newComment) {
        super(program, enumDt.getComment(valueName), newComment);
        this.enumm = enumDt;
        this.valueName = valueName;
    }

    @Override
    public String getActionName() {
        return "Update";
    }

    @Override
    public String getItemType() {
        return "Enum Comment";
    }

    @Override
    public Address getAddress() {
        return null;
    }

    @Override
    public String getPath() {
        return this.enumm.getCategoryPath().getPath();
    }

    @Override
    public String doGetCurrent() {
        return this.enumm.getComment(this.valueName);
    }

    @Override
    public void execute() {
        try {
            long value = this.enumm.getValue(this.valueName);
            this.enumm.remove(this.valueName);
            this.enumm.add(this.valueName, value, this.replacement);
        }
        catch (Exception e) {
            this.setStatus(QuickFixStatus.ERROR, "Update enum comment failed: " + e.getMessage());
        }
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    protected boolean navigateSpecial(ServiceProvider services, boolean fromSelectionChange) {
        DataTypeManagerService dtmService = (DataTypeManagerService)services.getService(DataTypeManagerService.class);
        if (dtmService == null) {
            return false;
        }
        dtmService.setDataTypeSelected((DataType)this.enumm);
        if (!fromSelectionChange) {
            dtmService.edit((DataType)this.enumm);
        }
        return true;
    }

    @Override
    public Map<String, String> getCustomToolTipData() {
        return Map.of("Datatype", this.enumm.getPathName());
    }
}

