/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import db.TerminatedTransactionException;
import ghidra.SwingExceptionHandler;
import ghidra.framework.model.DomainObjectException;
import ghidra.framework.model.DomainObjectLockedException;
import ghidra.util.Msg;

public class GhidraThreadGroup
extends ThreadGroup {
    public GhidraThreadGroup() {
        super(Thread.currentThread().getThreadGroup(), "Ghidra");
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        GhidraThreadGroup.handleUncaughtException(e);
    }

    public static void handleUncaughtException(Throwable t) {
        if (t instanceof DomainObjectException) {
            t = t.getCause();
        }
        if (t instanceof TerminatedTransactionException) {
            Msg.showError(GhidraThreadGroup.class, null, (String)"Terminated Transaction", (Object)"Transaction has been terminated!\n \nAll open transactions must be closed before a new transaction will be allowed.\nTry cancelling all long running tasks.\n \nNote that this error may be repeated until all running tasks are terminated.");
            return;
        }
        if (t instanceof DomainObjectLockedException) {
            Msg.showError(GhidraThreadGroup.class, null, (String)"Transaction Not Allowed", (Object)(t.getMessage() + "\n \nNo modifications are permitted until the locking process has completed."));
            return;
        }
        SwingExceptionHandler.handleUncaughtException((Throwable)t);
    }
}

