/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class ProfileGuidedOptimizationDataMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4444;
    private long invocations;
    private long dynamicInstructionCount;
    private long staticInstructionCount;
    private long postInliningStaticInstructionCount;

    public ProfileGuidedOptimizationDataMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.invocations = reader.parseUnsignedIntVal();
        this.dynamicInstructionCount = reader.parseLong();
        this.staticInstructionCount = reader.parseUnsignedIntVal();
        this.postInliningStaticInstructionCount = reader.parseUnsignedIntVal();
    }

    @Override
    public int getPdbId() {
        return 4444;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s:\n", this.getSymbolTypeName()));
        builder.append(String.format("Call Count: %d\n", this.invocations));
        builder.append(String.format("Dynamic Instruction Count: %d\n", this.dynamicInstructionCount));
        builder.append(String.format("Number of Instructions: %d\n", this.staticInstructionCount));
        builder.append(String.format("Number of Live Instructions: %d\n", this.postInliningStaticInstructionCount));
    }

    @Override
    protected String getSymbolTypeName() {
        return "POGOINFO";
    }
}

