/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.pcode.PackedDecode;

public class PackedDecodeOverlay
extends PackedDecode {
    private OverlayAddressSpace overlay = null;

    public PackedDecodeOverlay(AddressFactory addrFactory, OverlayAddressSpace spc) throws AddressFormatException {
        super(addrFactory);
        this.setOverlay(spc);
    }

    public void setOverlay(OverlayAddressSpace spc) throws AddressFormatException {
        AddressSpace underlie;
        if (this.overlay != null) {
            this.spaces[underlie.getUnique()] = underlie = this.overlay.getOverlayedSpace();
            this.overlay = null;
        }
        if ((underlie = spc.getOverlayedSpace()).getUnique() == 0 || underlie.getUnique() >= this.spaces.length) {
            throw new AddressFormatException("Cannot set overlay over " + underlie.getName());
        }
        this.spaces[underlie.getUnique()] = spc;
        this.overlay = spc;
    }
}

