/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.module.FragmentDBAdapter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class FragmentDBAdapterV0
extends FragmentDBAdapter {
    static final int V0_VERSION = 0;
    static final int V0_FRAGMENT_NAME_COL = 0;
    static final int V0_FRAGMENT_COMMENTS_COL = 1;
    static final Schema V0_FRAGMENT_SCHEMA = new Schema(0, "Key", new Field[]{StringField.INSTANCE, StringField.INSTANCE}, new String[]{"Name", "Comments"});
    private Table fragmentTable;

    public FragmentDBAdapterV0(DBHandle handle, boolean create, long treeID) throws VersionException, IOException {
        String tableName = FragmentDBAdapterV0.getTableName(treeID);
        if (create) {
            this.fragmentTable = handle.createTable(tableName, V0_FRAGMENT_SCHEMA, new int[]{0});
        } else {
            this.fragmentTable = handle.getTable(tableName);
            if (this.fragmentTable == null) {
                throw new VersionException("Missing Table: " + tableName);
            }
            int version = this.fragmentTable.getSchema().getVersion();
            if (version != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    public DBRecord createFragmentRecord(long parentFragmentID, String name) throws IOException {
        long key = this.fragmentTable.getKey();
        if (key == 0L) {
            key = 1L;
        }
        DBRecord record = V0_FRAGMENT_SCHEMA.createRecord(key);
        record.setString(0, name);
        this.fragmentTable.putRecord(record);
        return record;
    }

    @Override
    DBRecord getFragmentRecord(long key) throws IOException {
        return this.fragmentTable.getRecord(key);
    }

    @Override
    DBRecord getFragmentRecord(String name) throws IOException {
        Field[] keys = this.fragmentTable.findRecords((Field)new StringField(name), 0);
        if (keys.length == 0) {
            return null;
        }
        if (keys.length > 1) {
            throw new AssertException("Found " + keys.length + " fragments named " + name);
        }
        return this.fragmentTable.getRecord(keys[0]);
    }

    @Override
    void updateFragmentRecord(DBRecord record) throws IOException {
        this.fragmentTable.putRecord(record);
    }

    @Override
    boolean removeFragmentRecord(long childID) throws IOException {
        return this.fragmentTable.deleteRecord(childID);
    }
}

