/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.code.CommentHistoryAdapter;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressRecordDeleter;
import ghidra.program.model.address.Address;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class CommentHistoryAdapterV0
extends CommentHistoryAdapter {
    private Table table;
    private String userName;
    private AddressMap addrMap;

    CommentHistoryAdapterV0(DBHandle handle, AddressMap addrMap, boolean create) throws VersionException, IOException {
        this.addrMap = addrMap;
        if (create) {
            this.table = handle.createTable("Comment History", COMMENT_HISTORY_SCHEMA, new int[]{0});
        } else {
            this.table = handle.getTable("Comment History");
            if (this.table == null) {
                throw new VersionException(true);
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException(2, false);
            }
        }
        this.userName = SystemUtilities.getUserName();
    }

    @Override
    void createRecord(long addr, byte commentType, int pos1, int pos2, String data, long date) throws IOException {
        DBRecord rec = this.table.getSchema().createRecord(this.table.getKey());
        rec.setLongValue(0, addr);
        rec.setByteValue(1, commentType);
        rec.setIntValue(2, pos1);
        rec.setIntValue(3, pos2);
        rec.setString(4, data);
        rec.setString(5, this.userName);
        rec.setLongValue(6, date);
        this.table.putRecord(rec);
    }

    @Override
    RecordIterator getRecordsByAddress(Address address) throws IOException {
        LongField field = new LongField(this.addrMap.getKey(address, false));
        return this.table.indexIterator(0, (Field)field, (Field)field, true);
    }

    @Override
    RecordIterator getAllRecords() throws IOException {
        return new AddressKeyRecordIterator(this.table, this.addrMap);
    }

    @Override
    void updateRecord(DBRecord rec) throws IOException {
        this.table.putRecord(rec);
    }

    @Override
    boolean deleteRecords(Address start, Address end) throws IOException {
        return AddressRecordDeleter.deleteRecords(this.table, this.addrMap, start, end);
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }
}

