/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.semantics;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.semantics.ConstructTpl;
import ghidra.pcodeCPort.semantics.OpTpl;
import ghidra.pcodeCPort.translate.UnimplError;

public abstract class PcodeBuilder {
    private int labelbase;
    private int labelcount;

    protected abstract void dump(OpTpl var1);

    public PcodeBuilder(int lbcnt) {
        this.labelbase = this.labelcount = lbcnt;
    }

    public void dispose() {
    }

    public int getLabelBase() {
        return this.labelbase;
    }

    public abstract void appendBuild(OpTpl var1, int var2);

    public abstract void appendCrossBuild(OpTpl var1, int var2);

    public abstract void delaySlot(OpTpl var1);

    public abstract void setLabel(OpTpl var1);

    public void build(ConstructTpl construct, int secnum) {
        if (construct == null) {
            throw new UnimplError("", 0);
        }
        int oldbase = this.labelbase;
        this.labelbase = this.labelcount;
        this.labelcount += construct.numLabels();
        VectorSTL<OpTpl> ops = construct.getOpvec();
        IteratorSTL iter = ops.begin();
        while (!iter.isEnd()) {
            OpTpl op = (OpTpl)iter.get();
            switch (op.getOpcode()) {
                case CPUI_MULTIEQUAL: {
                    this.appendBuild(op, secnum);
                    break;
                }
                case CPUI_INDIRECT: {
                    this.delaySlot(op);
                    break;
                }
                case CPUI_PTRADD: {
                    this.setLabel(op);
                    break;
                }
                case CPUI_PTRSUB: {
                    this.appendCrossBuild(op, secnum);
                    break;
                }
                default: {
                    this.dump(op);
                }
            }
            iter.increment();
        }
        this.labelbase = oldbase;
    }
}

