/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.Application;
import ghidra.framework.protocol.ghidra.GhidraURL;
import java.io.File;
import java.net.URL;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ProjectLocator {
    public static final String PROJECT_FILE_SUFFIX = ".gpr";
    public static final String PROJECT_DIR_SUFFIX = ".rep";
    private static final String LOCK_FILE_SUFFIX = ".lock";
    private final String name;
    private final String location;
    private URL url;
    public static Set<Character> DISALLOWED_CHARS = Set.of(Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('&'), Character.valueOf('?'), Character.valueOf('#'));

    public ProjectLocator(String path, String name) {
        if (name.contains("/") || name.contains("\\")) {
            throw new IllegalArgumentException("name contains path separator character: " + name);
        }
        ProjectLocator.checkInvalidChar("name", name, 0);
        if (name.endsWith(PROJECT_FILE_SUFFIX)) {
            name = name.substring(0, name.length() - PROJECT_FILE_SUFFIX.length());
        }
        this.name = name;
        if (StringUtils.isBlank((CharSequence)path)) {
            path = Application.getUserTempDirectory().getAbsolutePath();
        }
        this.location = ProjectLocator.checkAbsolutePath(path);
        this.url = GhidraURL.makeURL(this.location, name);
    }

    private static void checkInvalidChar(String type, String str, int startIndex) {
        for (int i = startIndex; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!DISALLOWED_CHARS.contains(Character.valueOf(c))) continue;
            throw new IllegalArgumentException(type + " contains invalid character: '" + c + "'");
        }
    }

    private static String checkAbsolutePath(String path) {
        int scanIndex = 0;
        path = ((String)path).replace('\\', '/');
        int len = ((String)path).length();
        if (!((String)path).startsWith("/")) {
            if (len < 3 || !ProjectLocator.hasAbsoluteDriveLetter((String)path, 0)) {
                throw new IllegalArgumentException("absolute path required");
            }
            path = "/" + (String)path;
            scanIndex = 3;
        } else if (len >= 3 && ProjectLocator.hasDriveLetter((String)path, 1)) {
            if (len < 4 || ((String)path).charAt(3) != '/') {
                throw new IllegalArgumentException("absolute path required");
            }
            scanIndex = 4;
        }
        ProjectLocator.checkInvalidChar("path", (String)path, scanIndex);
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return path;
    }

    private static boolean hasDriveLetter(String path, int index) {
        return Character.isLetter(path.charAt(index++)) && path.charAt(index) == ':';
    }

    private static boolean hasAbsoluteDriveLetter(String path, int index) {
        int pathIndex = index + 2;
        return path.length() > pathIndex && ProjectLocator.hasDriveLetter(path, index) && path.charAt(pathIndex) == '/';
    }

    public boolean isTransient() {
        return false;
    }

    public URL getURL() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public File getProjectDir() {
        return new File(this.location, this.name + PROJECT_DIR_SUFFIX);
    }

    public File getMarkerFile() {
        return new File(this.location, this.name + PROJECT_FILE_SUFFIX);
    }

    public File getProjectLockFile() {
        return new File(this.location, this.name + LOCK_FILE_SUFFIX);
    }

    public static String getProjectDirExtension() {
        return PROJECT_DIR_SUFFIX;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectLocator projectLocator = (ProjectLocator)obj;
        return this.name.equals(projectLocator.name) && this.location.equals(projectLocator.location);
    }

    public int hashCode() {
        return this.name.hashCode() + this.location.hashCode();
    }

    public String toString() {
        return GhidraURL.getDisplayString(this.url);
    }

    public static String getProjectExtension() {
        return PROJECT_FILE_SUFFIX;
    }

    public static boolean isProjectDir(File file) {
        return file.isDirectory() && file.getName().endsWith(PROJECT_DIR_SUFFIX);
    }

    public boolean exists() {
        return this.getMarkerFile().isFile() && this.getProjectDir().isDirectory();
    }
}

