/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.LongKeyIndexer;
import ghidra.util.datastruct.Prime;
import java.io.Serializable;

public class LongObjectHashtable<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LongKeyIndexer indexer;
    private T[] values;
    private int capacity;

    public LongObjectHashtable() {
        this(3);
    }

    public LongObjectHashtable(int capacity) {
        this.capacity = capacity = Prime.nextPrime(capacity);
        this.indexer = new LongKeyIndexer(capacity);
        this.values = new Object[capacity];
    }

    public void put(long key, T value) {
        int index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.grow();
        }
        this.values[index] = value;
    }

    public T get(long key) {
        int index = this.indexer.get(key);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public T remove(long key) {
        int index = this.indexer.remove(key);
        if (index < 0) {
            return null;
        }
        T obj = this.values[index];
        this.values[index] = null;
        return obj;
    }

    public void removeAll() {
        this.indexer.clear();
    }

    public boolean contains(long key) {
        return this.indexer.get(key) >= 0;
    }

    public int size() {
        return this.indexer.getSize();
    }

    public long[] getKeys() {
        return this.indexer.getKeys();
    }

    private void grow() {
        this.capacity = this.indexer.getCapacity();
        T[] oldValues = this.values;
        this.values = new Object[this.capacity];
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }
}

