/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.props;

import com.google.gson.JsonElement;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.props.ExtProperty;
import sarif.managers.PropertiesSarifMgr;

public class SarifPropertyListWriter
extends AbstractExtWriter {
    Program program;
    List<String> options;

    public SarifPropertyListWriter(Program program, List<String> request, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.program = program;
        this.options = request;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genList(monitor);
        this.root.add("properties", (JsonElement)this.objects);
    }

    private void genList(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.options.size());
        for (String listName : this.options) {
            Options propList = this.program.getOptions(listName);
            List propNames = propList.getOptionNames();
            Collections.sort(propNames);
            for (String name : propNames) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                if (propList.isAlias(name) || propList.isDefaultValue(name)) continue;
                String keyName = listName + Options.DELIMITER_STRING + name;
                ExtProperty isf = new ExtProperty(keyName, propList);
                SarifObject sarif = new SarifObject(PropertiesSarifMgr.SUBKEY, PropertiesSarifMgr.KEY, this.getTree(isf), null);
                this.objects.add(this.getTree(sarif));
            }
        }
    }
}

