/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.action.ActionContextProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.ToolBarData;
import docking.actions.KeyBindingUtils;
import docking.options.editor.FontEditor;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import generic.theme.GIcon;
import generic.theme.Gui;
import generic.theme.ThemeManager;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.plugins.fsbrowser.FileSystemBrowserPlugin;
import ghidra.util.Msg;
import ghidra.util.datastruct.FixedSizeStack;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import resources.Icons;

public class TextEditorComponentProvider
extends ComponentProviderAdapter {
    private static final String TITLE = "Text Editor";
    private static final String FONT_ID = "font.plugin.service.text.editor";
    private static final int MAX_UNDO_REDO_SIZE = 50;
    private static final String LAST_SAVED_TEXT_FILE_DIR = "LastSavedTextFileDirectory";
    private File textFile;
    private String textFileName;
    private DockingAction saveAction;
    private DockingAction saveAsAction;
    private DockingAction undoAction;
    private DockingAction redoAction;
    private DockingAction fontAction;
    private JTextArea textarea;
    private JScrollPane scrollpane;
    private boolean isChanged = false;
    private String title;
    private FixedSizeStack<UndoableEdit> undoStack = new FixedSizeStack(50);
    private FixedSizeStack<UndoableEdit> redoStack = new FixedSizeStack(50);

    public TextEditorComponentProvider(FileSystemBrowserPlugin plugin, String textFileName, String text) {
        super(plugin.getTool(), TITLE, plugin.getName());
        this.textFileName = textFileName;
        this.initialize(text);
    }

    public String getText() {
        return this.textarea.getText();
    }

    private void initialize(String textContents) {
        this.title = this.textFileName + (this.isReadOnly() ? " (Read-Only) " : "");
        this.setTitle(this.title);
        this.textarea = new KeyMasterTextArea(textContents);
        this.scrollpane = new JScrollPane(this.textarea);
        this.scrollpane.setPreferredSize(new Dimension(400, 400));
        this.addToTool();
        this.setVisible(true);
        this.createActions();
        this.contextChanged();
    }

    private boolean isReadOnly() {
        return this.textFile != null;
    }

    private void clearUndoRedoStack() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.contextChanged();
    }

    private void undo() {
        UndoableEdit item = (UndoableEdit)this.undoStack.pop();
        this.redoStack.push((Object)item);
        item.undo();
        this.contextChanged();
    }

    private void redo() {
        UndoableEdit item = (UndoableEdit)this.redoStack.pop();
        this.undoStack.push((Object)item);
        item.redo();
        this.contextChanged();
    }

    boolean isChanged() {
        return this.isChanged;
    }

    private void setChanged(boolean changed) {
        if (this.isChanged == changed) {
            return;
        }
        if (!changed) {
            this.clearUndoRedoStack();
        }
        this.isChanged = changed;
        if (this.saveAction != null && !this.isReadOnly()) {
            this.saveAction.setEnabled(this.isChanged);
        }
        if (this.isChanged) {
            this.setTitle("*" + this.title);
        } else {
            this.setTitle(this.title);
        }
    }

    private void createActions() {
        this.undoAction = new DockingAction("Undo", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                TextEditorComponentProvider.this.undo();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return !TextEditorComponentProvider.this.undoStack.isEmpty();
            }
        };
        this.undoAction.setDescription("Undo");
        this.undoAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.undo"), "UndoRedo"));
        this.undoAction.setKeyBindingData(new KeyBindingData("ctrl z"));
        this.addLocalAction((DockingActionIf)this.undoAction);
        this.redoAction = new DockingAction("Redo", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                TextEditorComponentProvider.this.redo();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return !TextEditorComponentProvider.this.redoStack.isEmpty();
            }
        };
        this.redoAction.setDescription("Redo");
        this.redoAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.redo"), "UndoRedo"));
        this.redoAction.setKeyBindingData(new KeyBindingData("ctrl shift z"));
        this.addLocalAction((DockingActionIf)this.redoAction);
        this.saveAction = new DockingAction("Save File", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                TextEditorComponentProvider.this.save();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return TextEditorComponentProvider.this.isChanged;
            }
        };
        this.saveAction.setDescription("Save");
        this.saveAction.setToolBarData(new ToolBarData(Icons.SAVE_ICON, "Save"));
        this.saveAction.setKeyBindingData(new KeyBindingData("ctrl-s"));
        this.addLocalAction((DockingActionIf)this.saveAction);
        this.saveAsAction = new DockingAction("Save File As", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                TextEditorComponentProvider.this.saveAs();
            }
        };
        this.saveAsAction.setDescription("Save As...");
        this.saveAsAction.setToolBarData(new ToolBarData(Icons.SAVE_AS_ICON, "Save"));
        this.addLocalAction((DockingActionIf)this.saveAsAction);
        this.fontAction = new DockingAction("Select Font", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                TextEditorComponentProvider.this.doSelectFont();
            }
        };
        this.fontAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.font"), "ZZFont"));
        this.fontAction.setDescription("Select Font");
        this.addLocalAction((DockingActionIf)this.fontAction);
        ActionContextProvider acp = e -> {
            TextEditorComponentProvider p = this;
            return new DefaultActionContext((ComponentProvider)p);
        };
        KeyBindingUtils.registerAction((JComponent)this.textarea, (DockingAction)this.saveAction, (ActionContextProvider)acp);
        KeyBindingUtils.registerAction((JComponent)this.textarea, (DockingAction)this.redoAction, (ActionContextProvider)acp);
        KeyBindingUtils.registerAction((JComponent)this.textarea, (DockingAction)this.undoAction, (ActionContextProvider)acp);
    }

    protected void doSelectFont() {
        FontEditor editor = new FontEditor();
        editor.setValue((Object)Gui.getFont((String)FONT_ID));
        editor.showDialog();
        ThemeManager.getInstance().setFont(FONT_ID, (Font)editor.getValue());
    }

    private void save() {
        String text = this.textarea.getText();
        if (this.textFile == null) {
            this.saveAs();
        } else {
            try {
                PrintWriter writer = new PrintWriter(new FileWriter(this.textFile));
                writer.print(text);
                writer.close();
                this.setChanged(false);
            }
            catch (IOException e) {
                if (this.textFile.canWrite()) {
                    Msg.showError(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Error Saving File", (Object)"Unable to save file", (Throwable)e);
                }
                Msg.showError(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Error Saving File", (Object)"The file is not writable");
            }
        }
    }

    private void saveAs() {
        int result;
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.getComponent());
        chooser.setLastDirectoryPreference(LAST_SAVED_TEXT_FILE_DIR);
        File saveAsFile = chooser.getSelectedFile();
        chooser.dispose();
        if (saveAsFile == null) {
            return;
        }
        boolean exists = saveAsFile.exists();
        if (exists && (result = OptionDialog.showYesNoDialog((Component)this.getComponent(), (String)this.getName(), (String)("Do you want to OVERWRITE the following file:\n" + saveAsFile.getName()))) != 1) {
            return;
        }
        try {
            String str = this.textarea.getText();
            PrintWriter writer = new PrintWriter(new FileWriter(saveAsFile));
            writer.print(str);
            writer.close();
            this.saveAction.setEnabled(false);
            this.textFile = saveAsFile;
            this.title = saveAsFile.getName();
            this.setChanged(false);
        }
        catch (IOException e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Error Saving File As...", (Object)e.getMessage());
        }
    }

    public void closeComponent() {
        this.clearUndoRedoStack();
        super.closeComponent();
        this.getTool().removeComponentProvider((ComponentProvider)this);
    }

    public JComponent getComponent() {
        return this.scrollpane;
    }

    private class KeyMasterTextArea
    extends JTextArea {
        private KeyMasterTextArea(String text) {
            super(text);
            Gui.registerFont((Component)this, (String)TextEditorComponentProvider.FONT_ID);
            this.setName("EDITOR");
            this.setWrapStyleWord(false);
            Document document = this.getDocument();
            document.addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    TextEditorComponentProvider.this.setChanged(true);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    TextEditorComponentProvider.this.setChanged(true);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    TextEditorComponentProvider.this.setChanged(true);
                }
            });
            document.addUndoableEditListener(e -> {
                UndoableEdit item = e.getEdit();
                TextEditorComponentProvider.this.undoStack.push((Object)item);
                TextEditorComponentProvider.this.redoStack.clear();
                TextEditorComponentProvider.this.contextChanged();
            });
            this.setCaretPosition(0);
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            InputMap map = this.getInputMap(condition);
            ActionMap am = this.getActionMap();
            if (map != null && am != null && this.isEnabled()) {
                Action action;
                Object binding = map.get(ks);
                Action action2 = action = binding == null ? null : am.get(binding);
                if (action != null) {
                    if (!action.isEnabled()) {
                        e.consume();
                        return true;
                    }
                    return SwingUtilities.notifyAction(action, ks, e, this, e.getModifiersEx());
                }
            }
            return false;
        }
    }
}

