/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import docking.widgets.button.GRadioButton;
import ghidra.features.base.memsearch.gui.MemorySearchProvider;
import ghidra.features.base.memsearch.scan.Scanner;
import ghidra.util.HelpLocation;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MemoryScanControlPanel
extends JPanel {
    private Scanner selectedScanner = Scanner.NOT_EQUALS;
    private boolean hasResults;
    private boolean isBusy;
    private JButton scanButton;

    MemoryScanControlPanel(MemorySearchProvider provider) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.add((Component)this.buildButtonPanel(), "Center");
        this.scanButton = new JButton("Scan Values");
        this.scanButton.setToolTipText("Refreshes byte values of current results and eliminates those that don't meet the selected change criteria");
        HelpService helpService = Help.getHelpService();
        helpService.registerHelp((Object)this, new HelpLocation("Search", "Scan_Controls"));
        this.add((Component)this.scanButton, "West");
        this.scanButton.addActionListener(e -> provider.scan(this.selectedScanner));
    }

    private JComponent buildButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Scanner scanner : Scanner.values()) {
            GRadioButton button = new GRadioButton(scanner.getName());
            buttonGroup.add((AbstractButton)button);
            panel.add((Component)button);
            button.setSelected(scanner == this.selectedScanner);
            button.addActionListener(e -> {
                this.selectedScanner = scanner;
            });
            button.setToolTipText(scanner.getDescription());
        }
        return panel;
    }

    public void setSearchStatus(boolean hasResults, boolean isBusy) {
        this.hasResults = hasResults;
        this.isBusy = isBusy;
        this.updateScanButton();
    }

    private void updateScanButton() {
        this.scanButton.setEnabled(this.canScan());
    }

    private boolean canScan() {
        return this.hasResults && !this.isBusy;
    }
}

