/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.field.VariableXRefFieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.app.util.viewer.proxy.VariableProxy;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableXRefHeaderFieldLocation;
import java.awt.Color;
import java.math.BigInteger;

public class VariableXRefHeaderFieldFactory
extends VariableXRefFieldFactory {
    private static final String FIELD_NAME = "Variable XRef Header";

    public VariableXRefHeaderFieldFactory() {
        super(FIELD_NAME);
    }

    public VariableXRefHeaderFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, ToolOptions fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.colorOptionName = "XRef Color";
        this.styleOptionName = "XRef Style";
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Variable)) {
            return null;
        }
        String headString = this.getXRefHeaderString(obj);
        if (headString == null || headString.length() == 0) {
            return null;
        }
        AttributedString as = new AttributedString(headString, (Color)ListingColors.XrefColors.DEFAULT, this.getMetrics());
        TextFieldElement text = new TextFieldElement(as, 0, 0);
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)text, this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        Variable sv;
        VariableXRefHeaderFieldLocation xRefHeaderLoc;
        if (!(loc instanceof VariableXRefHeaderFieldLocation)) {
            return null;
        }
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Variable && (xRefHeaderLoc = (VariableXRefHeaderFieldLocation)loc).isLocationFor(sv = (Variable)obj)) {
            return new FieldLocation(index, fieldNum, xRefHeaderLoc.getIndex(), xRefHeaderLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj<?> proxy = bf.getProxy();
        if (proxy instanceof VariableProxy) {
            VariableProxy variableProxy = (VariableProxy)proxy;
            Variable sv = variableProxy.getObject();
            return new VariableXRefHeaderFieldLocation(sv.getProgram(), sv, col, null);
        }
        return null;
    }

    private String getXRefHeaderString(Object obj) {
        Reference[] vrefs;
        if (obj == null || !(obj instanceof Variable)) {
            return null;
        }
        Variable var = (Variable)obj;
        int xrefCount = 0;
        int offcutCount = 0;
        Varnode varnode = var.getFirstStorageVarnode();
        if (varnode == null) {
            return null;
        }
        Address varAddr = varnode.getAddress();
        Program program = var.getFunction().getProgram();
        ReferenceManager refMgr = program.getReferenceManager();
        for (Reference vref : vrefs = refMgr.getReferencesTo(var)) {
            if (vref.getToAddress().equals((Object)varAddr)) {
                ++xrefCount;
                continue;
            }
            ++offcutCount;
        }
        if (xrefCount > 0 || offcutCount > 0) {
            if (offcutCount > 0) {
                return "XREF[" + xrefCount + "," + offcutCount + "]:";
            }
            return "XREF[" + xrefCount + "]:";
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Variable.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 3;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new VariableXRefHeaderFieldFactory(formatModel, provider, (Options)displayOptions, fieldOptions);
    }
}

