/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html.diff;

import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiffInput;
import ghidra.app.util.html.diff.DiffLines;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;

class DiffLinesValidator {
    private final List<ValidatableLine> myLines;
    private int marker = 0;
    private DataTypeDiffInput input;
    private boolean isLeft;

    DiffLinesValidator(DataTypeDiffInput input, boolean isLeft) {
        this.input = input;
        this.isLeft = isLeft;
        this.myLines = new ArrayList<ValidatableLine>(input.getLines());
    }

    DiffLines getValidatedLines() {
        if (!this.isDone()) {
            throw new AssertException("Cannot get validated lines before validation is finished");
        }
        return new DiffLines(this.input, this.myLines);
    }

    public String toString() {
        return "Diff Validator (" + (this.isLeft ? "left" : "right") + ")\n" + this.toString(this.myLines);
    }

    private String toString(List<?> list) {
        StringBuffer buffer = new StringBuffer("[ ");
        for (int i = 0; i < list.size(); ++i) {
            buffer.append(this.markup(i, list.get(i).toString()));
            if (i + 1 >= list.size()) continue;
            buffer.append(", ");
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    private String markup(int lineNumber, String string) {
        if (lineNumber != this.marker) {
            return string;
        }
        String flag = " ****** ";
        String[] lines = string.split("\n");
        StringBuilder buffy = new StringBuilder();
        for (String line : lines) {
            if (line.trim().isEmpty()) {
                buffy.append(line).append('\n');
                continue;
            }
            buffy.append(flag).append(line).append(flag).append('\n');
            flag = "        ";
        }
        return buffy.toString();
    }

    PlaceHolderLine insertMismatchPlaceholder(int index, ValidatableLine oppositeLine) {
        PlaceHolderLine placeHolder = this.input.createPlaceHolder(oppositeLine);
        this.insertLine(index, placeHolder);
        return placeHolder;
    }

    private <T extends ValidatableLine> void insertLine(int markerPosition, ValidatableLine line) {
        this.myLines.add(markerPosition, line);
    }

    int getMarkerPosition() {
        return this.marker;
    }

    public void increment() {
        ++this.marker;
        while (this.marker < this.myLines.size()) {
            ValidatableLine line = this.myLines.get(this.marker);
            if (!line.isValidated()) {
                return;
            }
            ++this.marker;
        }
    }

    ValidatableLine getLine() {
        while (this.marker < this.myLines.size()) {
            ValidatableLine line = this.myLines.get(this.marker);
            if (!(line instanceof PlaceHolderLine)) {
                return line;
            }
            if (!line.isValidated()) {
                return line;
            }
            ++this.marker;
        }
        return null;
    }

    Integer findNextMatch(ValidatableLine line) {
        for (int searchPosition = 0; searchPosition < this.myLines.size(); ++searchPosition) {
            ValidatableLine myNextLine = this.myLines.get(searchPosition);
            if (!line.matches(myNextLine)) continue;
            return searchPosition;
        }
        return null;
    }

    boolean isDone() {
        return this.marker >= this.myLines.size();
    }

    ValidatableLine getLine(int index) {
        return this.myLines.get(index);
    }

    int indexOf(ValidatableLine sourceLine) {
        return this.myLines.indexOf(sourceLine);
    }

    int size() {
        return this.myLines.size();
    }
}

