/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.format.golang.rtti.GoSymbolNameType;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public record GoSymbolName(String symbolName, String packagePath, String packageName, String receiverString, String genericInfo, String baseName, String prefix, GoSymbolNameType symtype) {
    private static final Pattern TYPE_PREFIX_PATTERN = Pattern.compile("^(type[:.]\\.([a-z]+)\\.)(.*?[^\u00b7]+)(\u00b7[0-9]+)?$");
    private static final Pattern TYPE_PREFIX_SUB_PATTERN = Pattern.compile("^type[:.]\\.([a-z]+)\\.$");
    private static final String GO_SHAPE_PREFIX = "go.shape.";
    private static final Map<Character, Character> NESTING_ENDCHARS = Map.of(Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'));

    private GoSymbolName(String symbolName) {
        this(symbolName, null, null, null, null, null, null, GoSymbolNameType.UNKNOWN);
    }

    public static String fixGolangSpecialSymbolnameChars(String s) {
        if (s.contains("\u00b7") || s.contains("\u2215")) {
            s = s.replaceAll("\u00b7", ".").replaceAll("\u2215", "/");
        }
        return s;
    }

    public static GoSymbolName parseTypeName(String s, String packagePath) {
        int typeNameStart;
        int packagePathEnd;
        int endOfPrefix = GoSymbolName.indexOfAny(s, "*[]0123456789.", 0, false);
        if (endOfPrefix == -1) {
            endOfPrefix = 0;
        }
        String prefixStr = s.substring(0, endOfPrefix);
        int typeNameLimit = GoSymbolName.indexOfAny(s = s.substring(endOfPrefix), " {([", 0, true);
        if (typeNameLimit == -1) {
            typeNameLimit = s.length();
        }
        boolean foundAbsPkgPath = (packagePathEnd = s.lastIndexOf(47, typeNameLimit - 1)) >= 0;
        Object packageStr = "";
        if (foundAbsPkgPath) {
            packageStr = s.substring(0, packagePathEnd + 1);
            s = s.substring(packagePathEnd + 1);
            typeNameLimit -= packagePathEnd + 1;
        }
        if ((typeNameStart = s.lastIndexOf(46, typeNameLimit - 1)) >= 0) {
            packageStr = (String)packageStr + s.substring(0, typeNameStart);
            s = s.substring(typeNameStart + 1);
        }
        String typeName = s;
        if (!foundAbsPkgPath && packagePath != null && !packagePath.isEmpty() && packagePath.endsWith((String)packageStr)) {
            packageStr = packagePath;
        }
        String canonicalName = prefixStr + (String)packageStr + (!((String)packageStr).isEmpty() && !((String)packageStr).endsWith("/") ? "." : "") + typeName;
        return new GoSymbolName(canonicalName, (String)packageStr, GoSymbolName.extractPackageName((String)packageStr), null, null, typeName, prefixStr, GoSymbolNameType.DATA_TYPE);
    }

    public static GoSymbolName parse(String s) {
        GoSymbolName result = GoSymbolName._parse(s);
        return result != null ? result : new GoSymbolName(s);
    }

    private static GoSymbolName _parse(String s) {
        String baseSymbolName;
        int lastSlash;
        int pkgDot;
        if (s.startsWith("go:")) {
            return null;
        }
        String origStr = s;
        Matcher m = TYPE_PREFIX_PATTERN.matcher(s);
        if (m.matches()) {
            String prefixStr = m.group(1);
            String typeStr = m.group(3);
            GoSymbolName typeSN = GoSymbolName.parseTypeName(typeStr, "");
            return new GoSymbolName(s, typeSN.packagePath, typeSN.packageName, null, null, typeStr, prefixStr, GoSymbolNameType.FUNC);
        }
        s = GoSymbolName.fixGolangSpecialSymbolnameChars(origStr);
        int pkgInfoLimit = GoSymbolName.indexOfAny(s, "([");
        if (pkgInfoLimit == -1) {
            pkgInfoLimit = s.length();
        }
        if ((pkgDot = s.indexOf(46, (lastSlash = s.lastIndexOf(47, pkgInfoLimit)) + 1)) < 0) {
            return null;
        }
        String pkgStr = s.substring(0, pkgDot);
        List<String> parts = GoSymbolName.splitNestedStringOn(s.substring(pkgDot + 1), '.');
        String firstPart = parts.get(0);
        int baseIndex = 0;
        String recvStr = null;
        String genericsStr = null;
        if (firstPart.startsWith("(") && firstPart.endsWith(")")) {
            String[] recvParts = GoSymbolName.splitGenerics(firstPart.substring(1, firstPart.length() - 1));
            recvStr = recvParts[0];
            genericsStr = recvParts[1];
            ++baseIndex;
        }
        if (baseIndex == 0 && parts.size() == 1) {
            String[] nameParts = GoSymbolName.splitGenerics(firstPart);
            baseSymbolName = nameParts[0];
            genericsStr = nameParts[1];
        } else {
            baseSymbolName = String.join((CharSequence)".", parts.subList(baseIndex, parts.size()));
        }
        GoSymbolNameType type = parts.size() == baseIndex + 1 ? GoSymbolNameType.fromNameWithDashSuffix(parts.get(parts.size() - 1)) : GoSymbolNameType.fromNameSuffix(parts.get(parts.size() - 1));
        return new GoSymbolName(origStr, pkgStr, GoSymbolName.extractPackageName(pkgStr), recvStr, genericsStr, baseSymbolName, null, type);
    }

    private static String extractPackageName(String pkgStr) {
        int pkgNameStart = pkgStr.lastIndexOf(47);
        return pkgNameStart != -1 ? pkgStr.substring(pkgNameStart + 1) : pkgStr;
    }

    public static GoSymbolName from(String packageName, String symbolName) {
        return new GoSymbolName(symbolName, packageName, packageName, null, null, null, null, null);
    }

    public static GoSymbolName fromPackagePath(String packagePath) {
        GoSymbolName tmp = GoSymbolName.parse(packagePath + ".TMP");
        return new GoSymbolName(null, tmp.getPackagePath(), tmp.getPackageName(), null, null, null, null, null);
    }

    public boolean isMethod() {
        return this.receiverString != null;
    }

    public boolean hasGenerics() {
        return this.genericInfo != null;
    }

    public boolean isUnparsed() {
        return this.packagePath == null;
    }

    public boolean isAnonType() {
        return this.baseName != null && this.baseName.startsWith("struct { ");
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean hasReceiver() {
        return this.receiverString != null;
    }

    public String getReceiverString() {
        return this.receiverString == null || this.genericInfo == null || this.genericInfo.isEmpty() ? this.receiverString : "%s[%s]".formatted(this.receiverString, this.genericInfo);
    }

    public String getReceiverString(String modifiedGenerics) {
        return this.receiverString == null || modifiedGenerics == null || modifiedGenerics.isEmpty() ? this.receiverString : "%s[%s]".formatted(this.receiverString, modifiedGenerics);
    }

    public GoSymbolName getReceiverTypeName() {
        return GoSymbolName.parseTypeName(this.getReceiverString(), this.getPackagePath());
    }

    public GoSymbolName getReceiverTypeName(String modifiedGenerics) {
        return GoSymbolName.parseTypeName(this.getReceiverString(modifiedGenerics), this.getPackagePath());
    }

    public String getShapelessGenericsString() {
        if (this.genericInfo == null) {
            return null;
        }
        List<String> genericParts = this.getGenericParts();
        return genericParts.stream().map(s -> s.startsWith(GO_SHAPE_PREFIX) ? s.substring(GO_SHAPE_PREFIX.length()) : s).collect(Collectors.joining(","));
    }

    public String getStrippedReceiverString() {
        return this.receiverString;
    }

    public String getGenericsString() {
        return this.genericInfo;
    }

    public List<String> getGenericParts() {
        return GoSymbolName.splitNestedStringOn(this.genericInfo, ',');
    }

    public String getStrippedSymbolString() {
        if (this.packagePath == null) {
            return this.symbolName;
        }
        return this.isMethod() ? "%s.(%s).%s".formatted(this.packagePath, this.getStrippedReceiverString(), this.baseName) : "%s.%s".formatted(this.packagePath, this.baseName);
    }

    public GoSymbolName asNonPtrReceiverSymbolName() {
        int dotIndex;
        int n = dotIndex = this.baseName != null ? this.baseName.indexOf(46) : -1;
        if (dotIndex == -1) {
            return null;
        }
        String newRecv = this.baseName.substring(0, dotIndex);
        String newBase = this.baseName.substring(dotIndex + 1);
        GoSymbolNameType newType = newBase.endsWith("-fm") ? GoSymbolNameType.METHOD_WRAPPER : this.symtype;
        return new GoSymbolName(this.symbolName, this.packagePath, this.packageName, newRecv, this.genericInfo, newBase, this.prefix, newType);
    }

    public boolean isNonPtrReceiverCandidate() {
        int dotIndex = this.baseName != null ? this.baseName.indexOf(46) : -1;
        return dotIndex != -1 && this.baseName.lastIndexOf(46) == dotIndex;
    }

    public String asString() {
        return this.symbolName;
    }

    @Override
    public final String toString() {
        return this.symbolName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getBaseTypeName() {
        return Objects.requireNonNullElse(this.prefix, "") + this.baseName;
    }

    public GoSymbolNameType getNameType() {
        return this.symtype;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTypePrefixSubKeyword() {
        Matcher m = TYPE_PREFIX_SUB_PATTERN.matcher(Objects.requireNonNullElse(this.prefix, ""));
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public String getTruncatedPackagePath() {
        return this.packagePath != null && this.packageName != null && this.packagePath.length() > this.packageName.length() ? this.packagePath.substring(0, this.packagePath.length() - this.packageName.length()) : null;
    }

    public Namespace getSymbolNamespace(Program program) {
        Namespace rootNS = program.getGlobalNamespace();
        if (this.packagePath != null && !this.packagePath.isBlank()) {
            try {
                return program.getSymbolTable().getOrCreateNameSpace(rootNS, this.packagePath, SourceType.IMPORTED);
            }
            catch (DuplicateNameException | InvalidInputException throwable) {
                // empty catch block
            }
        }
        return rootNS;
    }

    public Function getFunction(Program program) {
        Namespace ns = this.getSymbolNamespace(program);
        Symbol sym = SymbolUtilities.getUniqueSymbol((Program)program, (String)this.asString(), (Namespace)ns);
        Function func = sym instanceof FunctionSymbol ? (Function)sym.getObject() : null;
        return func;
    }

    private static int indexOfAny(String s, String chars) {
        return GoSymbolName.indexOfAny(s, chars, 0, true);
    }

    private static int indexOfAny(String s, String chars, int start, boolean charsMatch) {
        for (int i = start; i < s.length(); ++i) {
            boolean matches;
            char ch = s.charAt(i);
            boolean bl = matches = chars.indexOf(ch) != -1;
            if (matches != charsMatch) continue;
            return i;
        }
        return -1;
    }

    private static List<String> splitNestedStringOn(String s, char splitChar) {
        int codePoint;
        ArrayList<String> parts = new ArrayList<String>();
        ArrayDeque<Character> nestingstack = new ArrayDeque<Character>();
        int partStart = 0;
        block4: for (int i = 0; i < s.length(); i += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(i);
            switch (codePoint) {
                case 40: 
                case 91: 
                case 123: {
                    nestingstack.addLast(NESTING_ENDCHARS.get(Character.valueOf((char)codePoint)));
                    continue block4;
                }
                case 41: 
                case 93: 
                case 125: {
                    Character expectedEndChar = (Character)nestingstack.pollLast();
                    if (expectedEndChar != null && expectedEndChar.charValue() == (char)codePoint) continue block4;
                    return List.of(s);
                }
                default: {
                    if (codePoint != splitChar || !nestingstack.isEmpty()) continue block4;
                    parts.add(s.substring(partStart, i));
                    partStart = i + 1;
                }
            }
        }
        parts.add(s.substring(partStart));
        return parts;
    }

    static String[] splitGenerics(String s) {
        String[] result = new String[]{null, null};
        int genStart = s.indexOf(91);
        if (genStart != -1 && s.endsWith("]")) {
            result[0] = s.substring(0, genStart);
            result[1] = s.substring(genStart + 1, s.length() - 1);
        } else {
            result[0] = s;
        }
        return result;
    }
}

