/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.expression;

import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOpCodes;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOperandType;
import java.util.Arrays;

class DWARFExpressionOperation {
    protected final int offset;
    protected final int opcode;
    protected final DWARFExpressionOperandType[] operandTypes;
    protected final long[] operands;
    protected final byte[] blob;

    public DWARFExpressionOperation(int opcode, DWARFExpressionOperandType[] operandTypes, long[] operands, byte[] blob, int offset) {
        this.opcode = opcode;
        this.operandTypes = operandTypes;
        this.operands = operands;
        this.blob = blob;
        this.offset = offset;
    }

    public int getOpCode() {
        return this.opcode;
    }

    public long getOperandValue(int opindex) {
        return this.operands[opindex];
    }

    public int getRelativeOpCodeOffset(int baseOpCode) {
        return this.opcode - baseOpCode;
    }

    public byte[] getBlob() {
        return this.blob;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return DWARFExpressionOpCodes.toString(this.opcode) + " " + Arrays.toString(this.operands);
    }
}

