/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.store.LockException;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import javax.swing.tree.TreePath;

public class ClearArchiveArchitectureAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public ClearArchiveArchitectureAction(DataTypeManagerPlugin plugin) {
        super("Clear Archive Architecture", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Clear Architecture"}, null, "SetArch"));
        this.setDescription("Clear program-architecture associated with a data type archive (existing custom storage details will be discarded)");
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof FileArchiveNode) && !(node instanceof ProjectArchiveNode)) {
            return false;
        }
        ArchiveNode archiveNode = (ArchiveNode)node;
        StandAloneDataTypeManager dtm = (StandAloneDataTypeManager)archiveNode.getArchive().getDataTypeManager();
        return dtm.getProgramArchitectureSummary() != null && dtm.isUpdatable();
    }

    public void actionPerformed(ActionContext context) {
        String msg;
        int response;
        ProjectArchiveNode paNode;
        ProjectArchive pa;
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof FileArchiveNode) && !(node instanceof ProjectArchiveNode)) {
            return;
        }
        if (node instanceof ProjectArchiveNode && !(pa = (ProjectArchive)(paNode = (ProjectArchiveNode)node).getArchive()).hasExclusiveAccess()) {
            Msg.showError((Object)((Object)this), null, (String)"Clear Program Architecture Failed", (Object)"Clearing program-architecture on Project Archive requires exclusive checkout.");
            return;
        }
        ArchiveNode archiveNode = (ArchiveNode)node;
        StandAloneDataTypeManager dtm = (StandAloneDataTypeManager)archiveNode.getArchive().getDataTypeManager();
        if (dtm.isChanged()) {
            if (1 != OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Save Archive Changes", (String)"Archive has unsaved changes which must be saved before continuing.\nThis is required to allow for a reversion to the previous saved state.", (String)"Save")) {
                return;
            }
            try {
                archiveNode.getArchive().save();
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"Save Archive Failed", (Object)("Failed to save changes for Archive: " + dtm.getName() + "\n" + e.getMessage()));
                return;
            }
        }
        if ((response = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Confirm Clearing Archive Architecture", (String)(msg = "<html>Clear program-architecture for Archive?<BR><font color=\"" + String.valueOf(GThemeDefaults.Colors.Messages.NORMAL) + "\">" + dtm.getPath() + "</font><BR> <BR>Archive will revert to using default data organization."), (String)"Clear Architecture", (int)2)) != 1) {
            return;
        }
        new TaskLauncher((Task)new ClearProgramArchitectureTask(archiveNode.getArchive(), dtm));
    }

    private class ClearProgramArchitectureTask
    extends Task {
        private final Archive archive;
        private final StandAloneDataTypeManager dtm;

        public ClearProgramArchitectureTask(Archive archive, StandAloneDataTypeManager dtm) {
            super("Clearing Program-Architecture for Archive", true, false, true, false);
            this.archive = archive;
            this.dtm = dtm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) throws CancelledException {
            boolean success = false;
            try {
                this.dtm.clearProgramArchitecture(monitor);
                success = true;
            }
            catch (CancelledException e) {
                throw e;
            }
            catch (Exception e) {
                Msg.showError((Object)((Object)this), null, (String)"Archive Update Failed", (Object)("Failed to clear program-architecture for Archive: " + this.dtm.getName() + "\n" + e.getMessage()));
            }
            finally {
                if (!success) {
                    if (this.archive instanceof FileArchive) {
                        try {
                            ((FileArchive)this.archive).releaseWriteLock();
                            ((FileArchive)this.archive).acquireWriteLock();
                        }
                        catch (LockException | IOException e) {
                            this.archive.close();
                        }
                    } else {
                        this.archive.close();
                        DomainFile df = ((ProjectArchive)this.archive).getDomainFile();
                        ClearArchiveArchitectureAction.this.plugin.openArchive(df);
                    }
                }
            }
        }
    }
}

