/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import db.util.ErrorHandler;
import ghidra.app.plugin.core.compositeeditor.IDMapDB;
import ghidra.program.database.DatabaseObject;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import javax.help.UnsupportedOperationException;
import utility.function.Callback;

public class CompositeViewerDataTypeManager<T extends Composite>
extends StandAloneDataTypeManager
implements ErrorHandler {
    private final DataTypeManager originalDTM;
    private final T originalComposite;
    private final T viewComposite;
    private final IDMapDB dataTypeIDMap;
    private Callback restoredCallback;
    private Callback changeCallback;
    private int transactionId = 0;
    private boolean dataTypeChanged;
    private long flattenModCount = -1L;
    private TreeSet<Long> orphanIds = new TreeSet();

    public CompositeViewerDataTypeManager(String rootName, DataTypeManager originalDTM) {
        this(rootName, originalDTM, null, null, null);
        this.transactionId = this.startTransaction("Composite Edit");
    }

    public CompositeViewerDataTypeManager(String rootName, T originalComposite, Callback changeCallback, Callback restoredCallback) {
        this(rootName, originalComposite.getDataTypeManager(), originalComposite, changeCallback, restoredCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeViewerDataTypeManager(String rootName, DataTypeManager originalDTM, T originalComposite, Callback changeCallback, Callback restoredCallback) {
        super(rootName, originalDTM.getDataOrganization());
        this.originalDTM = originalDTM;
        this.originalComposite = originalComposite;
        this.changeCallback = changeCallback;
        this.restoredCallback = restoredCallback;
        int txId = this.startTransaction("Setup for Edit");
        try {
            this.initializeArchitecture();
            this.dataTypeIDMap = new IDMapDB(this.dbHandle, this);
            this.viewComposite = this.resolveViewComposite();
        }
        finally {
            this.endTransaction(txId, true);
        }
        this.clearUndo();
    }

    private T resolveViewComposite() {
        return (T)(this.originalComposite != null ? (Composite)super.resolve(this.originalComposite, null) : null);
    }

    private void initializeArchitecture() {
        ProgramArchitecture arch = this.originalDTM.getProgramArchitecture();
        if (arch != null) {
            try {
                this.setProgramArchitecture(arch, null, true, TaskMonitor.DUMMY);
            }
            catch (CancelledException e) {
                throw new AssertException((Throwable)e);
            }
            catch (IOException e) {
                this.errHandler.dbError(e);
            }
        }
    }

    public long getModCount() {
        return this.dbHandle.getModCount();
    }

    protected synchronized void clearUndo() {
        super.clearUndo();
    }

    public void undo() {
        if (!this.isUndoRedoAllowed()) {
            throw new UnsupportedOperationException();
        }
        this.dataTypeIDMap.invalidate();
        super.undo();
    }

    public void redo() {
        if (!this.isUndoRedoAllowed()) {
            throw new UnsupportedOperationException();
        }
        this.dataTypeIDMap.invalidate();
        super.redo();
    }

    public T getResolvedViewComposite() {
        return this.viewComposite;
    }

    public boolean isUndoRedoAllowed() {
        return this.restoredCallback != null;
    }

    protected final boolean isArchitectureChangeAllowed() {
        return false;
    }

    public synchronized void close() {
        if (this.transactionId != 0) {
            super.endTransaction(this.transactionId, true);
        }
        super.close();
    }

    public DataTypeManager getOriginalDataTypeManager() {
        return this.originalDTM;
    }

    public ArchiveType getType() {
        return this.originalDTM.getType();
    }

    public boolean allowsDefaultBuiltInSettings() {
        return this.originalDTM.allowsDefaultBuiltInSettings();
    }

    public DataType resolve(DataType dataType, DataTypeConflictHandler handler) {
        if (dataType == this.originalComposite && this.viewComposite != null) {
            return this.viewComposite;
        }
        DataType resolvedDt = super.resolve(dataType, handler);
        if (dataType instanceof DatabaseObject && this.originalDTM.contains(dataType)) {
            long originalId = this.originalDTM.getID(dataType);
            long myId = this.getID(resolvedDt);
            this.dataTypeIDMap.put(myId, originalId);
        }
        return resolvedDt;
    }

    public DataType replaceDataType(DataType existingViewDt, DataType replacementDt, boolean updateCategoryPath) throws DataTypeDependencyException {
        DataType newResolvedDt;
        if (existingViewDt.getDataTypeManager() != this) {
            throw new IllegalArgumentException("datatype is not from this manager");
        }
        if (existingViewDt instanceof DatabaseObject) {
            this.dataTypeIDMap.remove(this.getID(existingViewDt));
        }
        if ((newResolvedDt = super.replaceDataType(existingViewDt, replacementDt, updateCategoryPath)) instanceof DatabaseObject && replacementDt.getDataTypeManager() == this.originalDTM) {
            long originalId = this.originalDTM.getID(replacementDt);
            long myId = this.getID(newResolvedDt);
            this.dataTypeIDMap.put(myId, originalId);
        }
        return newResolvedDt;
    }

    public boolean remove(DataType existingViewDt, TaskMonitor monitor) {
        if (existingViewDt.getDataTypeManager() != this) {
            throw new IllegalArgumentException("datatype is not from this manager");
        }
        if (existingViewDt instanceof DatabaseObject) {
            this.dataTypeIDMap.remove(this.getID(existingViewDt));
        }
        return super.remove(existingViewDt, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshDBTypesFromOriginal() {
        TreeSet<Long> treeSet = this.orphanIds;
        synchronized (treeSet) {
            return (Boolean)this.withTransaction("DataTypes Restored", () -> {
                boolean changed = false;
                this.clearUndoOnChange();
                Iterator allDataTypes = this.getAllDataTypes();
                while (allDataTypes.hasNext()) {
                    Long originalId;
                    DataType dt = (DataType)allDataTypes.next();
                    if (dt == this.viewComposite || !(dt instanceof DatabaseObject)) continue;
                    long myId = this.getID(dt);
                    if (this.viewComposite != null) {
                        this.orphanIds.add(myId);
                    }
                    if ((originalId = this.dataTypeIDMap.getOriginalIDFromViewID(myId)) == null) continue;
                    DataType originalDt = this.originalDTM.getDataType(originalId.longValue());
                    if (originalDt == null) {
                        changed = true;
                        this.remove(dt, TaskMonitor.DUMMY);
                        continue;
                    }
                    if (!originalDt.isEquivalent(dt)) {
                        changed = true;
                        try {
                            originalDt = this.replaceDataType(dt, originalDt, true);
                        }
                        catch (DataTypeDependencyException e) {
                            throw new AssertException((Throwable)e);
                        }
                    }
                    CategoryPath path = dt.getCategoryPath();
                    if (originalDt.getCategoryPath().equals((Object)path)) continue;
                    Category newDtCat = this.createCategory(path);
                    try {
                        newDtCat.moveDataType(dt, null);
                    }
                    catch (DataTypeDependencyException e) {
                        throw new AssertException((Throwable)e);
                    }
                }
                this.checkOrphansForRemoval(true);
                return changed;
            });
        }
    }

    public void dataTypeChanged(DataType dt, boolean isAutoChange) {
        super.dataTypeChanged(dt, isAutoChange);
        if (dt == this.viewComposite) {
            this.dataTypeChanged = true;
        }
    }

    public void notifyRestored() {
        super.notifyRestored();
        if (this.restoredCallback != null) {
            Swing.runLater(() -> this.restoredCallback.call());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean endTransaction(int transactionID, boolean commit) {
        if (this.viewComposite != null && this.getTransactionCount() == 1) {
            TreeSet<Long> treeSet = this.orphanIds;
            synchronized (treeSet) {
                this.checkOrphansForRemoval(false);
            }
        }
        boolean committed = super.endTransaction(transactionID, commit);
        if (!this.isTransactionActive() && this.flattenModCount != -1L) {
            if (this.flattenModCount != this.dbHandle.getModCount()) {
                this.clearUndo();
            }
            this.flattenModCount = -1L;
        }
        if (committed && this.dataTypeChanged && this.changeCallback != null) {
            Swing.runLater(() -> this.changeCallback.call());
        }
        if (this.getTransactionCount() == 0) {
            this.dataTypeChanged = false;
        }
        return committed;
    }

    private void checkOrphansForRemoval(boolean cleanupIdMaps) {
        while (!this.orphanIds.isEmpty()) {
            DataType dt;
            long id = (Long)this.orphanIds.removeFirst();
            if (this.hasParent(id) || !((dt = this.getDataType(id)) instanceof DatabaseObject) || dt == this.viewComposite) continue;
            this.orphanIds.addAll(this.getChildIds(id));
            this.remove(dt, TaskMonitor.DUMMY);
            if (!cleanupIdMaps) continue;
            this.dataTypeIDMap.remove(id);
        }
    }

    public synchronized void clearUndoOnChange() {
        if (this.flattenModCount == -1L) {
            this.flattenModCount = this.dbHandle.getModCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeParentChildRecord(long parentID, long childID) {
        super.removeParentChildRecord(parentID, childID);
        if (this.viewComposite != null) {
            TreeSet<Long> treeSet = this.orphanIds;
            synchronized (treeSet) {
                if (!this.hasParent(childID)) {
                    this.orphanIds.add(childID);
                }
            }
        }
    }

    public DataType findMyDataTypeFromOriginalID(long originalId) {
        Long myId = this.dataTypeIDMap.getViewIDFromOriginalID(originalId);
        return myId != null ? this.getDataType(myId) : null;
    }

    public DataType findOriginalDataTypeFromMyID(long myId) {
        Long originalId = this.dataTypeIDMap.getOriginalIDFromViewID(myId);
        return originalId != null ? this.originalDTM.getDataType(originalId.longValue()) : null;
    }

    public boolean isViewDataTypeFromOriginalDTM(DataType existingViewDt) {
        if (existingViewDt.getDataTypeManager() != this) {
            throw new IllegalArgumentException("datatype is not from this manager");
        }
        if (!(existingViewDt instanceof DatabaseObject)) {
            return false;
        }
        return this.dataTypeIDMap.getOriginalIDFromViewID(this.getID(existingViewDt)) != null;
    }
}

