/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeView;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.symbol.TraceSymbolView;
import ghidra.util.LazyCollection;
import ghidra.util.MergeSortingIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DBTraceSymbolMultipleTypesView<T extends AbstractDBTraceSymbol>
implements TraceSymbolView<T> {
    protected final DBTraceSymbolManager manager;
    protected final Collection<? extends AbstractDBTraceSymbolSingleTypeView<? extends T>> parts;

    public DBTraceSymbolMultipleTypesView(DBTraceSymbolManager manager, Collection<? extends AbstractDBTraceSymbolSingleTypeView<? extends T>> parts) {
        this.manager = manager;
        this.parts = parts;
    }

    @Override
    public TraceSymbolManager getManager() {
        return this.manager;
    }

    @SafeVarargs
    public DBTraceSymbolMultipleTypesView(DBTraceSymbolManager manager, AbstractDBTraceSymbolSingleTypeView<? extends T> ... parts) {
        this(manager, Arrays.asList(parts));
    }

    @Override
    public Collection<? extends T> getAll(boolean includeDynamicSymbols) {
        return new LazyCollection(() -> this.parts.stream().flatMap(p -> p.getAll(includeDynamicSymbols).stream()));
    }

    @Override
    public Collection<? extends T> getChildrenNamed(String name, TraceNamespaceSymbol parent) {
        return this.parts.stream().flatMap(p -> p.getChildrenNamed(name, parent).stream()).toList();
    }

    @Override
    public Collection<? extends T> getChildren(TraceNamespaceSymbol parent) {
        return new LazyCollection(() -> this.parts.stream().flatMap(p -> p.getChildren(parent).stream()));
    }

    @Override
    public Collection<? extends T> getNamed(String name) {
        return this.parts.stream().flatMap(p -> p.getNamed(name).stream()).toList();
    }

    @Override
    public Collection<? extends T> getWithMatchingName(String glob, boolean caseSensitive) {
        return new LazyCollection(() -> this.parts.stream().flatMap(p -> p.getWithMatchingName(glob, caseSensitive).stream()));
    }

    @Override
    public Iterator<? extends T> scanByName(String startName) {
        List iterators = this.parts.stream().map(p -> p.scanByName(startName)).collect(Collectors.toList());
        return new MergeSortingIterator(iterators, Comparator.comparing(s -> s.getName()));
    }
}

