/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;

public class ClangOpToken
extends ClangToken {
    private PcodeOp op = null;

    public ClangOpToken(ClangNode par) {
        super(par);
    }

    @Override
    public PcodeOp getPcodeOp() {
        return this.op;
    }

    @Override
    public Address getMinAddress() {
        if (this.op == null) {
            return null;
        }
        return this.op.getSeqnum().getTarget();
    }

    @Override
    public Address getMaxAddress() {
        if (this.op == null) {
            return null;
        }
        return this.op.getSeqnum().getTarget();
    }

    @Override
    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        int attribId;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId != AttributeId.ATTRIB_OPREF.id()) continue;
            int refid = (int)decoder.readUnsignedInteger();
            this.op = pfactory.getOpRef(refid);
        }
        decoder.rewindAttributes();
        super.decode(decoder, pfactory);
    }
}

