/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashBasicDirectoryInode;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import java.io.IOException;

public class SquashExtendedDirectoryInode
extends SquashBasicDirectoryInode {
    private int indexCount;
    private long xattrIndex;

    public SquashExtendedDirectoryInode(BinaryReader reader, SquashSuperBlock superBlock) throws IOException {
        super(reader, superBlock, true);
        this.hardLinkCount = reader.readNextUnsignedInt();
        this.uncompressedFileSize = reader.readNextUnsignedInt();
        this.blockIndex = reader.readNextUnsignedInt();
        this.parentInodeNumber = reader.readNextUnsignedIntExact();
        this.indexCount = reader.readNextUnsignedShort();
        this.blockOffset = reader.readNextUnsignedShort();
        this.xattrIndex = reader.readNextUnsignedInt();
        for (int i = 0; i < this.indexCount; ++i) {
            this.skipDirectoryListing(reader);
        }
        this.parentIsRoot = (long)this.parentInodeNumber == superBlock.getInodeCount() + 1L;
    }

    private void skipDirectoryListing(BinaryReader reader) throws IOException {
        long index = reader.readNextUnsignedInt();
        long start = reader.readNextUnsignedInt();
        int nameSize = reader.readNextInt();
        String name = reader.readNextAsciiString(nameSize + 1);
    }

    long getXattrIndex() {
        return this.xattrIndex;
    }
}

