/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SparseSwitchPayload
implements StructConverter {
    public static final short MAGIC = 512;
    private short ident;
    private short size;
    private int[] keys;
    private int[] targets;

    public SparseSwitchPayload(BinaryReader reader) throws IOException {
        this.ident = reader.readNextShort();
        this.size = reader.readNextShort();
        this.keys = reader.readNextIntArray(this.size & 0xFFFF);
        this.targets = reader.readNextIntArray(this.size & 0xFFFF);
    }

    public short getIdent() {
        return this.ident;
    }

    public short getSize() {
        return this.size;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] getTargets() {
        return this.targets;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("sparse_switch_payload_" + this.size, 0);
        structure.add(WORD, "ident", null);
        structure.add(WORD, "size", null);
        structure.add((DataType)new ArrayDataType(DWORD, this.size & 0xFFFF, DWORD.getLength()), "keys", null);
        structure.add((DataType)new ArrayDataType(DWORD, this.size & 0xFFFF, DWORD.getLength()), "targets", null);
        structure.setCategoryPath(new CategoryPath("/dex/sparse_switch_payload"));
        return structure;
    }
}

