/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AVR8_ElfRelocationType;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class AVR8_ElfRelocationHandler
extends AbstractElfRelocationHandler<AVR8_ElfRelocationType, ElfRelocationContext<?>> {
    public AVR8_ElfRelocationHandler() {
        super(AVR8_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 83;
    }

    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, AVR8_ElfRelocationType type, Address relocationAddress, ElfSymbol elfSymbol, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        switch (type) {
            case R_AVR_DIFF8: 
            case R_AVR_DIFF16: 
            case R_AVR_DIFF32: {
                return RelocationResult.SKIPPED;
            }
        }
        Program program = elfRelocationContext.getProgram();
        int symbolIndex = relocation.getSymbolIndex();
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        Memory memory = program.getMemory();
        long addend = relocation.getAddend();
        long offset = relocationAddress.getOffset();
        short oldValue = memory.getShort(relocationAddress);
        int newValue = 0;
        int byteLength = 2;
        switch (type) {
            case R_AVR_32: {
                newValue = (int)symbolValue + (int)addend & 0xFFFFFFFF;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case R_AVR_7_PCREL: {
                newValue = (int)(symbolValue * 2L + (long)((int)addend) - offset);
                if (((newValue -= 2) & 1) == 1) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                if (newValue > 127 || newValue < -128) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation overflow", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue = oldValue & 0xFC07 | newValue >> 1 << 3 & 0x3F8;
                memory.setShort(relocationAddress, (short)newValue);
                break;
            }
            case R_AVR_13_PCREL: {
                newValue = (int)(symbolValue * 2L + (long)((int)addend) - offset);
                if (((newValue -= 2) & 1) == 1) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                if ((newValue >>= 1) < -2048 || newValue > 2047) {
                    this.markAsWarning(program, relocationAddress, type, symbolName, symbolIndex, "Possible relocation error", elfRelocationContext.getLog());
                }
                newValue = oldValue & 0xF000 | newValue & 0xFFF;
                memory.setShort(relocationAddress, (short)newValue);
                break;
            }
            case R_AVR_16: {
                newValue = (int)symbolValue + (int)addend;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_16_PM: {
                newValue = (int)symbolValue * 2 + (int)addend;
                memory.setShort(relocationAddress, (short)((newValue >>= 1) & 0xFFFF));
                break;
            }
            case R_AVR_LO8_LDI: {
                newValue = (int)symbolValue + (int)addend;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_HI8_LDI: {
                newValue = (int)symbolValue + (int)addend;
                newValue = newValue >> 8 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_HH8_LDI: {
                newValue = (int)symbolValue + (int)addend;
                newValue = newValue >> 16 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_LO8_LDI_NEG: {
                newValue = (int)symbolValue + (int)addend;
                newValue = -newValue;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_HI8_LDI_NEG: {
                newValue = (int)symbolValue + (int)addend;
                newValue = -newValue;
                newValue = newValue >> 8 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_HH8_LDI_NEG: {
                newValue = (int)symbolValue + (int)addend;
                newValue = -newValue;
                newValue = newValue >> 16 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_LO8_LDI_PM: {
                newValue = (int)symbolValue * 2 + (int)addend;
                if ((newValue & 1) == 1) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_HI8_LDI_PM: {
                newValue = (int)symbolValue * 2 + (int)addend;
                if ((newValue & 1) == 1) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = newValue >> 8 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_HH8_LDI_PM: {
                newValue = (int)symbolValue * 2 + (int)addend;
                if ((newValue & 1) == 1) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = newValue >> 16 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_LO8_LDI_PM_NEG: {
                newValue = (int)symbolValue * 2 + (int)addend;
                newValue = -newValue;
                if ((newValue & 1) == 1) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_HI8_LDI_PM_NEG: {
                newValue = (int)symbolValue * 2 + (int)addend;
                newValue = -newValue;
                if ((newValue & 1) == 1) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = newValue >> 8 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_HH8_LDI_PM_NEG: {
                newValue = (int)symbolValue * 2 + (int)addend;
                newValue = -newValue;
                if ((newValue & 1) == 1) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = newValue >> 16 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_CALL: {
                newValue = (int)symbolValue * 2 + (int)addend;
                if ((newValue & 1) == 1) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                int hiValue = oldValue | ((newValue >>= 1) & 0x10000 | newValue << 3 & 0x1F00000) >> 16;
                memory.setShort(relocationAddress, (short)(hiValue & 0xFFFF));
                memory.setShort(relocationAddress.add(2L), (short)(newValue & 0xFFFF));
                byteLength = 4;
                break;
            }
            case R_AVR_LDI: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) > 255) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                }
                newValue = newValue >> 8 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_6: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) > 63 || newValue < 0) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                }
                newValue = oldValue & 0xD3F8 | newValue & 7 | (newValue & 0x18) << 7 | (newValue & 0x20) << 8;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_6_ADIW: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) > 63 || newValue < 0) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                }
                newValue = oldValue & 0xFF30 | newValue & 0xF | (newValue & 0x30) << 2;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_LDS_STS_16: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) < 64 || (newValue & 0xFFFF) > 191) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                }
                newValue &= 0x7F;
                newValue = oldValue & 0xF | (newValue & 0x30) << 5 | (newValue & 0x40) << 2;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_PORT6: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) > 63) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                }
                newValue = oldValue & 0xF9F0 | (newValue & 0x30) << 5 | newValue & 0xF;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case R_AVR_PORT5: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) > 31) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Relocation out of range", elfRelocationContext.getLog());
                }
                newValue = oldValue & 0xFF07 | (newValue & 0x1F) << 3;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

