/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.ui.GroupValidator;
import org.netbeans.validation.api.ui.ValidationItem;
import org.netbeans.validation.api.ui.ValidationListenerFactory;
import org.netbeans.validation.api.ui.ValidationStrategy;
import org.netbeans.validation.api.ui.ValidationUI;

public class ValidationGroup
extends ValidationItem {
    private final GroupValidator additionalGroupValidation;
    private final List<ValidationItem> validationItems = new LinkedList<ValidationItem>();
    private boolean isAncestorToSelf = false;

    protected ValidationGroup(GroupValidator additionalGroupValidation, ValidationUI ... ui) {
        super(ui);
        this.additionalGroupValidation = additionalGroupValidation;
        if (ui == null) {
            throw new NullPointerException("UI null");
        }
    }

    protected ValidationGroup(ValidationUI ... ui) {
        this((GroupValidator)null, ui);
    }

    public static ValidationGroup create(ValidationUI ... ui) {
        return new ValidationGroup(ui);
    }

    public static ValidationGroup create(GroupValidator additionalGroupValidation, ValidationUI ... ui) {
        return new ValidationGroup(additionalGroupValidation, ui);
    }

    @SafeVarargs
    public final <ComponentType, ValueType> void add(ComponentType comp, Validator<ValueType> ... validators) {
        this.addItem(ValidationListenerFactory.createValidationListener(comp, ValidationStrategy.DEFAULT, this.decorationFor(comp), ValidatorUtils.merge(validators)), false);
    }

    public final <ComponentType, ValueType> void add(ComponentType comp, Validator<ValueType> validator) {
        this.addItem(ValidationListenerFactory.createValidationListener(comp, ValidationStrategy.DEFAULT, this.decorationFor(comp), validator), false);
    }

    protected <T> ValidationUI decorationFor(T component) {
        return ValidationUI.NO_OP;
    }

    @Override
    public final void addUI(ValidationUI ui) {
        super.addUI(ui);
    }

    @Override
    public final void removeUI(ValidationUI ui) {
        super.removeUI(ui);
    }

    public final void addItem(ValidationItem validationItem, boolean disableUI) {
        if (validationItem.getParentValidationGroup() != null) {
            throw new IllegalArgumentException("Added item already has parent group");
        }
        validationItem.setParentValidationGroup(this, !disableUI);
        this.validationItems.add(0, validationItem);
        if (this.detectAncestryToSelf()) {
            this.validationItems.remove(0);
            validationItem.setParentValidationGroup(null, true);
            throw new IllegalArgumentException("Ancestry to self");
        }
        if (!this.isSuspended()) {
            this.update(false, null);
            if (this.getParentValidationGroup() != null) {
                this.getParentValidationGroup().validationTriggered(this);
            } else {
                this.showIfUIEnabled(this.getCurrentLeadProblem());
            }
        }
    }

    boolean detectAncestryToSelf() {
        if (this.isAncestorToSelf) {
            return true;
        }
        this.isAncestorToSelf = true;
        boolean badNews = false;
        if (this.getParentValidationGroup() != null) {
            badNews = this.getParentValidationGroup().detectAncestryToSelf();
        }
        this.isAncestorToSelf = false;
        return badNews;
    }

    public final void remove(ValidationItem validationItem) {
        if (this.validationItems.remove(validationItem)) {
            validationItem.setParentValidationGroup(null, true);
            if (this.getCurrentLeadProblem() != null && this.getCurrentLeadProblem() == validationItem.getCurrentLeadProblem() && !this.isSuspended()) {
                this.update(false, null);
                if (this.getParentValidationGroup() != null) {
                    this.getParentValidationGroup().validationTriggered(this);
                } else {
                    this.showIfUIEnabled(this.getCurrentLeadProblem());
                }
            }
        }
    }

    @Override
    final void subtreeRevalidation() {
        if (this.isSuspended()) {
            return;
        }
        this.update(true, null);
    }

    final void validationTriggered(ValidationItem triggeringChild) {
        assert (triggeringChild != null);
        assert (!this.isSuspended());
        this.validationItems.remove(triggeringChild);
        this.validationItems.add(0, triggeringChild);
        this.update(false, triggeringChild);
        if (this.getParentValidationGroup() != null) {
            this.getParentValidationGroup().validationTriggered(this);
        } else {
            this.showIfUIEnabled(this.getCurrentLeadProblem());
        }
    }

    private void update(boolean childrenShallPerformValidation, ValidationItem triggerThatHasAlreadyPerformedValidation) {
        assert (!this.isSuspended());
        assert (!childrenShallPerformValidation || triggerThatHasAlreadyPerformedValidation == null);
        Problems ps = new Problems();
        if (childrenShallPerformValidation) {
            for (ValidationItem vi : this.validationItems) {
                if (vi != triggerThatHasAlreadyPerformedValidation) {
                    vi.subtreeRevalidation();
                }
                ps.append(vi.getCurrentLeadProblem());
            }
        } else {
            for (ValidationItem vi : this.validationItems) {
                Problem p = vi.getCurrentLeadProblem();
                ps.append(p);
                if (p == null || !p.isFatal()) continue;
                break;
            }
        }
        Object leadProblem = ps.getLeadProblem();
        boolean haveUpdatedRelevantChildrenUI = false;
        if (this.additionalGroupValidation != null) {
            boolean theAdditionalProblemIsLeading = false;
            if (leadProblem == null || !leadProblem.isFatal()) {
                this.additionalGroupValidation.performGroupValidation(ps);
                Problem nue = ps.getLeadProblem();
                if (nue != null && !nue.equals(leadProblem)) {
                    theAdditionalProblemIsLeading = true;
                    leadProblem = nue;
                }
            }
            if (this.additionalGroupValidation.shallShowProblemInChildrenUIs()) {
                if (theAdditionalProblemIsLeading) {
                    for (ValidationItem vi : this.validationItems) {
                        vi.showIfUIEnabled((Problem)leadProblem);
                    }
                    haveUpdatedRelevantChildrenUI = true;
                } else if (this.additionalGroupValidation.isCurrentlyLeadingProblem()) {
                    for (ValidationItem vi : this.validationItems) {
                        vi.showIfUIEnabled(vi.getCurrentLeadProblem());
                    }
                    haveUpdatedRelevantChildrenUI = true;
                }
                this.additionalGroupValidation.setIsCurrentlyLeadingProblem(theAdditionalProblemIsLeading);
            }
        }
        if (!haveUpdatedRelevantChildrenUI) {
            if (triggerThatHasAlreadyPerformedValidation != null) {
                triggerThatHasAlreadyPerformedValidation.showIfUIEnabled(triggerThatHasAlreadyPerformedValidation.getCurrentLeadProblem());
            } else if (childrenShallPerformValidation) {
                for (ValidationItem vi : this.validationItems) {
                    vi.showIfUIEnabled(vi.getCurrentLeadProblem());
                }
            }
        }
        super.setCurrentLeadProblem((Problem)leadProblem);
    }
}

