/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class PrivateerMissionTest
extends FreeColTestCase {
    private static final GoodsType musketsType = PrivateerMissionTest.spec().getGoodsType("model.goods.muskets");
    private static final TileType plains = PrivateerMissionTest.spec().getTileType("model.tile.plains");
    private static final UnitType privateerType = PrivateerMissionTest.spec().getUnitType("model.unit.privateer");
    private static final UnitType galleonType = PrivateerMissionTest.spec().getUnitType("model.unit.galleon");

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    private void setupPrivateerTestMap(Game game) {
        Map map = game.getMap();
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile colonyTile = map.getTile(9, 9);
        Tile privateerTile = map.getTile(10, 9);
        Tile frenchGalleonTile = map.getTile(11, 9);
        Tile dutchGalleonTile = map.getTile(12, 9);
        PrivateerMissionTest.assertTrue((String)"Setup error, colony tile should be land", (boolean)colonyTile.isLand());
        PrivateerMissionTest.assertFalse((String)"Privateer tile should be ocean", (boolean)privateerTile.isLand());
        PrivateerMissionTest.assertFalse((String)"French galleon tile should be ocean", (boolean)frenchGalleonTile.isLand());
        PrivateerMissionTest.assertFalse((String)"Dutch galleon tile should be ocean", (boolean)dutchGalleonTile.isLand());
        this.getStandardColony(1, colonyTile.getX(), colonyTile.getY());
        new ServerUnit(game, privateerTile, dutch, privateerType);
        new ServerUnit(game, frenchGalleonTile, french, galleonType);
        new ServerUnit(game, dutchGalleonTile, dutch, galleonType);
    }

    private Game setupPrivateerTestGame() {
        ServerGame game = ServerTestHelper.startServerGame(PrivateerMissionTest.getCoastTestMap(plains));
        this.setupPrivateerTestMap(game);
        return game;
    }

    public void testIsMissionValid() {
        Game game = this.setupPrivateerTestGame();
        Map map = game.getMap();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        Tile privateerTile = map.getTile(10, 9);
        Tile dutchGalleonTile = map.getTile(12, 9);
        Unit privateer = privateerTile.getFirstUnit();
        PrivateerMissionTest.assertNotNull((String)"Setup error, could not get privateer", (Object)privateer);
        Unit dutchGalleon = dutchGalleonTile.getFirstUnit();
        PrivateerMissionTest.assertNotNull((String)"Setup error, could not get galleon", (Object)dutchGalleon);
        AIPlayer aiPlayer = aiMain.getAIPlayer(privateer.getOwner());
        AIUnit privateerAI = aiMain.getAIUnit(privateer);
        PrivateerMissionTest.assertNotNull((String)"Setup error, could not get privateerAI", (Object)privateerAI);
        privateerAI.changeMission(null);
        PrivateerMissionTest.assertFalse((String)"Privateer has no mission", (boolean)privateerAI.hasMission());
        PrivateerMissionTest.assertEquals((String)"PrivateeringMission valid", null, (String)PrivateerMission.invalidMissionReason(privateerAI));
    }
}

