# -*- coding: utf-8 -*-
# Copyright 2025 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the ios_l2_interfaces module
"""


class L2_interfacesArgs(object):  # pylint: disable=R0903
    """The arg spec for the ios_l2_interfaces module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str", "required": True},
                "access": {
                    "type": "dict",
                    "options": {
                        "vlan": {"type": "int"},
                        "vlan_name": {"type": "str"},
                    },
                },
                "voice": {
                    "type": "dict",
                    "options": {
                        "vlan": {"type": "int"},
                        "vlan_tag": {
                            "choices": ["dot1p", "none", "untagged"],
                            "type": "str",
                        },
                        "vlan_name": {"type": "str"},
                    },
                },
                "trunk": {
                    "type": "dict",
                    "options": {
                        "allowed_vlans": {"type": "list", "elements": "str"},
                        "native_vlan": {"type": "int"},
                        "encapsulation": {
                            "choices": ["dot1q", "isl", "negotiate"],
                            "type": "str",
                        },
                        "pruning_vlans": {"type": "list", "elements": "str"},
                    },
                },
                "xconnect": {
                    "type": "dict",
                    "options": {
                        "address": {"type": "str"},
                        "vcid": {"type": "int"},
                        "encapsulation": {
                            "type": "str",
                            "choices": ["mpls", "l2tpv3"],
                        },
                        "manual": {"type": "bool"},
                        "pw_class": {"type": "str"},
                        "sequencing": {
                            "type": "str",
                            "choices": ["both", "receive", "transmit"],
                        },
                    },
                },
                "mode": {
                    "type": "str",
                    "choices": [
                        "access",
                        "trunk",
                        "dot1q_tunnel",
                        "dynamic",
                        "dynamic_auto",
                        "dynamic_desirable",
                        "private_vlan_host",
                        "private_vlan_promiscuous",
                        "private_vlan_trunk",
                    ],
                },
                "private_vlan": {
                    "type": "dict",
                    "options": {
                        "association": {"type": "bool"},
                        "host_association": {"type": "bool"},
                        "mapping": {"type": "bool"},
                        "host": {"type": "bool"},
                        "primary_range": {"type": "int"},
                        "secondary_range": {"type": "int"},
                        "add": {"type": "bool"},
                        "remove": {"type": "bool"},
                        "secondary_vlan_id": {"type": "str"},
                    },
                },
                "app_interface": {"type": "bool"},
                "nonegotiate": {"type": "bool"},
                "vepa": {"type": "bool"},
                "host": {"type": "bool"},
                "protected": {"type": "bool"},
                "encapsulation": {
                    "type": "dict",
                    "options": {
                        "type": {"type": "str"},
                        "vlan_id": {"type": "int"},
                    },
                },
                "block_options": {
                    "type": "dict",
                    "options": {
                        "multicast": {"type": "bool"},
                        "unicast": {"type": "bool"},
                    },
                },
                "spanning_tree": {
                    "type": "dict",
                    "options": {
                        "bpdufilter": {
                            "type": "dict",
                            "options": {
                                "enabled": {"type": "bool"},
                                "disabled": {"type": "bool"},
                            },
                        },
                        "bpduguard": {
                            "type": "dict",
                            "options": {
                                "enabled": {"type": "bool"},
                                "disabled": {"type": "bool"},
                            },
                        },
                        "cost": {"type": "int"},
                        "guard": {
                            "type": "dict",
                            "options": {
                                "loop": {"type": "bool"},
                                "none": {"type": "bool"},
                                "root": {"type": "bool"},
                            },
                        },
                        "link_type": {
                            "type": "dict",
                            "options": {
                                "point_to_point": {"type": "bool"},
                                "shared": {"type": "bool"},
                            },
                        },
                        "mst": {
                            "type": "dict",
                            "options": {
                                "instance_range": {"type": "str"},
                                "cost": {"type": "str"},
                                "port_priority": {"type": "int"},
                            },
                        },
                        "port_priority": {"type": "int"},
                        "portfast": {
                            "type": "dict",
                            "options": {
                                "disabled": {"type": "bool"},
                                "trunk": {"type": "bool"},
                            },
                        },
                        "rootguard": {"type": "bool"},
                        "vlan": {
                            "type": "dict",
                            "options": {
                                "vlan_range": {"type": "str"},
                                "cost": {"type": "str"},
                                "port_priority": {"type": "int"},
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "rendered",
                "gathered",
                "parsed",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
