/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import java.io.IOException;

public class BigOperator
extends MathSymbol {
    protected int dispCodePoint;

    public BigOperator(String string, int n) {
        this(string, n, n);
    }

    public BigOperator(String string, int n, int n2) {
        super(string, n);
        this.dispCodePoint = n2;
    }

    @Override
    public Object clone() {
        return new BigOperator(this.getName(), this.getCharCode(), this.dispCodePoint);
    }

    public int getDispCharCode() {
        return this.dispCodePoint;
    }

    @Override
    public void write(TeXParser teXParser) throws IOException {
        int n;
        TeXSettings teXSettings = teXParser.getSettings();
        switch (teXSettings.getMode()) {
            case INLINE_MATH: {
                n = this.getCharCode();
                break;
            }
            case DISPLAY_MATH: {
                n = this.dispCodePoint;
                break;
            }
            default: {
                throw new TeXSyntaxException(teXParser, "tex.error.not_math_mode", this.toString(teXParser));
            }
        }
        TeXParserListener teXParserListener = teXParser.getListener();
        int n2 = teXSettings.getCharCode(n);
        teXParserListener.getWriteable().writeCodePoint(n2 == -1 ? n : n2);
    }
}

