-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULLIF(1, 1)
    AS INDEX_CATALOG,
  STRIP(SYSCAT.INDEXES.INDSCHEMA)
    AS INDEX_SCHEMA,
  STRIP(SYSCAT.INDEXES.TABNAME)
    AS TABLE_NAME,  
  STRIP(SYSCAT.INDEXES.INDNAME)
    AS INDEX_NAME, 
  SYSCAT.INDEXES.REMARKS
    AS REMARKS,
  NULL AS INDEX_DEFINITION,
  STRIP(SYSCAT.INDEXES.INDEXTYPE)
    AS INDEX_TYPE,
  SYSCAT.INDEXES.CREATE_TIME,
  SYSCAT.INDEXES.STATS_TIME
FROM
  SYSCAT.INDEXES
WITH UR
