-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  CURRENT_DATABASE()::INFORMATION_SCHEMA.SQL_IDENTIFIER AS INDEX_CATALOG,
  INDEXES.SCHEMANAME AS INDEX_SCHEMA,
  INDEXES.INDEXNAME AS INDEX_NAME,
  INDEXES.TABLENAME AS TABLE_NAME,
  PG_CATALOG.OBJ_DESCRIPTION(PGC.OID, 'pg_class') AS REMARKS,
  INDEXES.INDEXDEF AS INDEX_DEFINITION
FROM
  PG_INDEXES INDEXES
  INNER JOIN PG_CATALOG.PG_CLASS PGC
    ON INDEXES.INDEXNAME = PGC.RELNAME
ORDER BY
  INDEXES.SCHEMANAME,
  INDEXES.TABLENAME,
  INDEXES.INDEXNAME
