/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HttpConnection
extends Thread {
    public static final int optProxy = 210;
    private URL url = null;
    private ByteArrayOutputStream dataOs = null;
    private ByteArrayInputStream dataIs = null;
    private int proxyVer = 0;
    private String session = null;
    private Hashtable<Integer, StringBuffer> cookies = null;
    private StringBuffer reqProps = null;
    private Hashtable<String, String> resHdrs = null;
    static int STREAM_BUF_SIZE = 4096;
    private long interval = 0L;
    private long lastflush = 0L;
    private boolean flushInProgress = true;
    private boolean sendKeepAlives = false;

    public HttpConnection(String proxy) throws IOException {
        try {
            this.url = new URL(proxy);
        }
        catch (IOException e) {
            throw new IOException();
        }
        this.reqProps = new StringBuffer();
        this.cookies = new Hashtable();
        this.resHdrs = new Hashtable();
        this.dataOs = new ByteArrayOutputStream(STREAM_BUF_SIZE);
        this.dataIs = new ByteArrayInputStream(new byte[0]);
        this.updateFlushTime();
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.dataOs;
    }

    public ByteArrayInputStream getInputStream() {
        return this.dataIs;
    }

    public void flush(URLConnection conn) throws IOException {
        this.flushInProgress = true;
        this.sendRequest(conn);
        this.getResponse(conn);
        this.updateFlushTime();
        this.flushInProgress = false;
    }

    private void sendRequest(URLConnection conn) throws IOException {
        this.setCookies(conn);
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(conn.getOutputStream()));
            dos.writeShort(this.reqProps.toString().length());
            dos.writeBytes(this.reqProps.toString());
            this.reqProps = new StringBuffer();
            this.dataOs.writeTo(dos);
            this.dataOs.reset();
            dos.close();
        }
        catch (IOException e) {
            throw new IOException();
        }
    }

    private void getResponse(URLConnection conn) throws IOException {
        short msgLen = 0;
        short dataLen = 0;
        byte[] dataBytes = null;
        this.dataIs = null;
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
            msgLen = dis.readShort();
            if (msgLen == -1) {
                throw new IOException();
            }
            byte[] msgBytes = new byte[msgLen];
            dis.readFully(msgBytes, 0, msgLen);
            String hdr = new String(msgBytes, 0, (int)msgLen);
            try {
                this.parseResponse(hdr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dis.available() > 0) {
                dataLen = dis.readShort();
                if (dataLen != -1) {
                    dataBytes = new byte[dataLen];
                    dis.readFully(dataBytes);
                    this.dataIs = new ByteArrayInputStream(dataBytes);
                }
            } else {
                this.dataIs = new ByteArrayInputStream(new byte[0]);
            }
            dis.close();
        }
        catch (IOException e) {
            throw new IOException();
        }
    }

    public synchronized URLConnection openConnection(boolean useCaches, boolean doOutput, boolean doInput) throws IOException {
        URLConnection conn = null;
        try {
            conn = this.url.openConnection();
            conn.setUseCaches(useCaches);
            conn.setRequestProperty("Content-Type", "application/binary");
            conn.setDoOutput(doOutput);
            conn.setDoInput(doInput);
        }
        catch (IOException ioe) {
            throw new IOException();
        }
        return conn;
    }

    public String getHeaderField(String key) {
        String value = null;
        value = this.resHdrs.get(key);
        return value;
    }

    public void setRequestProperty(String key, String value) {
        this.reqProps.append(key + "=" + value + "&");
    }

    public void saveCookie(String str) {
        if (str != null) {
            StringTokenizer tok2 = null;
            StringBuffer buf = new StringBuffer();
            StringTokenizer tok = new StringTokenizer(str, ";");
            while (tok.hasMoreTokens()) {
                String keyval = tok.nextToken().trim();
                tok2 = new StringTokenizer(keyval, "=");
                String key = tok2.nextToken().trim();
                if (key.equalsIgnoreCase("Comment") || key.equalsIgnoreCase("Discard") || key.equalsIgnoreCase("Domain") || key.equalsIgnoreCase("Expires") || key.equalsIgnoreCase("Max-Age") || key.equalsIgnoreCase("Path") || key.equalsIgnoreCase("Secure") || key.equalsIgnoreCase("Version")) continue;
                buf.append(keyval + ";");
            }
            if (buf.length() > 0) {
                this.cookies.put(this.cookies.size(), buf);
            }
        }
    }

    public void setCookies(URLConnection conn) {
        if (this.cookies.size() > 0) {
            Enumeration<StringBuffer> e = this.cookies.elements();
            while (e.hasMoreElements()) {
                conn.setRequestProperty("Cookie", e.nextElement().toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseResponse(String hdr) throws Exception {
        this.resHdrs = new Hashtable();
        StringTokenizer token = null;
        TokenPhase phase = TokenPhase.NEW;
        boolean bquoted = false;
        String key = null;
        StringBuffer value = new StringBuffer();
        if (hdr == null) {
            return;
        }
        token = new StringTokenizer(hdr, ";=\"", true);
        while (token.hasMoreTokens()) {
            block32: {
                String ct;
                block31: {
                    ct = token.nextToken();
                    if (ct.length() != 1) break block31;
                    switch (ct.charAt(0)) {
                        case '\"': {
                            switch (phase) {
                                case EQUAL: {
                                    phase = TokenPhase.VALUE;
                                    bquoted = true;
                                    break block32;
                                }
                                case VALUE: {
                                    if (!bquoted) throw new Exception();
                                    bquoted = false;
                                    break block32;
                                }
                                default: {
                                    throw new Exception();
                                }
                            }
                        }
                        case ';': {
                            if (phase == TokenPhase.VALUE) {
                                if (bquoted) {
                                    value.append(ct);
                                } else {
                                    phase = TokenPhase.SEMICOLON;
                                }
                            } else {
                                if (phase != TokenPhase.EQUAL) throw new Exception();
                                phase = TokenPhase.SEMICOLON;
                            }
                            break block32;
                        }
                        case '=': {
                            switch (phase) {
                                case KEY: {
                                    phase = TokenPhase.EQUAL;
                                    break block32;
                                }
                                case VALUE: {
                                    if (!bquoted) throw new Exception();
                                    value.append(ct);
                                    break block32;
                                }
                                default: {
                                    throw new Exception();
                                }
                            }
                        }
                        case ' ': {
                            if (phase == TokenPhase.VALUE && bquoted) {
                                value.append(ct);
                            }
                            break block32;
                        }
                        default: {
                            if (phase != TokenPhase.VALUE || !bquoted) throw new Exception();
                            value.append(ct);
                            break block32;
                        }
                    }
                }
                switch (phase) {
                    case NEW: {
                        key = ct;
                        phase = TokenPhase.KEY;
                        break;
                    }
                    case EQUAL: {
                        value.append(ct);
                        phase = TokenPhase.VALUE;
                        break;
                    }
                    case VALUE: {
                        if (!bquoted) throw new Exception();
                        value.append(ct);
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
            }
            if (phase != TokenPhase.SEMICOLON) continue;
            this.resHdrs.put(key, value.toString());
            phase = TokenPhase.NEW;
            bquoted = false;
            key = null;
            value.delete(0, value.length());
        }
        switch (phase) {
            case EQUAL: 
            case KEY: {
                this.resHdrs.put(key, "");
                return;
            }
            case VALUE: 
            case SEMICOLON: {
                if (bquoted) {
                    throw new Exception();
                }
                this.resHdrs.put(key, value.toString());
            }
        }
    }

    public void updateURL(String inURL) throws IOException {
        try {
            this.url = new URL(inURL);
        }
        catch (IOException e) {
            throw new IOException();
        }
    }

    public void setProxyVersion(int version) {
        this.proxyVer = version;
    }

    public int getProxyVersion() {
        return this.proxyVer;
    }

    private synchronized void updateFlushTime() {
        this.lastflush = System.currentTimeMillis();
    }

    public void startKeepAlive(String session, long interval) throws IOException {
        this.interval = interval * 1000L;
        this.session = session;
        if (this.proxyVer >= 210) {
            this.sendKeepAlives = true;
            Thread keepalive = new Thread(this);
            keepalive.setDaemon(true);
            keepalive.setPriority(5);
            keepalive.start();
        }
    }

    @Override
    public void run() {
        StringBuffer keepStr = new StringBuffer();
        keepStr.append("JDBC_SESSION=" + this.session + "&" + "JDBC_REQUEST" + "=KEEPALIVE&");
        long timediff = 0L;
        long timenow = 0L;
        long sleepInt = this.interval;
        while (this.sendKeepAlives) {
            try {
                Thread.sleep(sleepInt);
                timenow = System.currentTimeMillis();
                timediff = timenow - this.lastflush;
                if (timediff >= this.interval) {
                    if (!this.flushInProgress && this.sendKeepAlives) {
                        try {
                            URLConnection conn = this.openConnection(false, true, true);
                            this.setCookies(conn);
                            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(conn.getOutputStream()));
                            dos.writeShort(keepStr.toString().length());
                            dos.writeBytes(keepStr.toString());
                            dos.close();
                            InputStream is = conn.getInputStream();
                            is.close();
                            this.updateFlushTime();
                            sleepInt = this.interval;
                        }
                        catch (IOException e) {
                            this.sendKeepAlives = false;
                        }
                        continue;
                    }
                    sleepInt = this.interval;
                    continue;
                }
                sleepInt = this.interval - timediff;
            }
            catch (InterruptedException e) {
                this.sendKeepAlives = false;
            }
        }
    }

    public void stopKeepAlive() throws IOException {
        this.sendKeepAlives = false;
    }

    private static enum TokenPhase {
        NEW,
        KEY,
        EQUAL,
        VALUE,
        SEMICOLON;

    }
}

