/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDistinct;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxRow;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxUDT;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.IfxTypes;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;

public class IfxValue {
    private static final HashMap<Integer, String> IfxTypeToObjectTable = new HashMap();
    private static final int IUS_TYPES = 10;
    private static final int NO_SCALE = -1;
    private static final String DISTINCT_CLASS_NAME = "IfxDistinct";
    private static final String BLOB_CLASS_NAME = "IfxSmBlob";
    private static final String CLOB_CLASS_NAME = "IfxSmBlob";
    private static final String SERVER_BLOB_CLASS_NAME = "IfxDirectBlob";
    private static final String SERVER_CLOB_CLASS_NAME = "IfxDirectClob";
    private static final String BOOLEAN_CLASS_NAME = "IfxBoolean";
    private static final String LVARCHAR_CLASS_NAME = "IfxLvarchar";
    private static final String UDT_CLASS_NAME = "IfxUDT";
    private static final String IMPEXP_CLASS_NAME = "IfxImpExp";
    private static final String BSON_CLASS_NAME = "IfxUDT";
    private static final String JSON_CLASS_NAME = "IfxJSON";

    private IfxValue() {
    }

    private static String IfxTypeToObject_9x(int ifxType) {
        return IfxTypeToObjectTable.get(ifxType);
    }

    private static int getRealIfxType(IfxConnection conn, int ifxtype) {
        if (!conn.isIEEEM() && IfxTypes.IsFloatTypes(ifxtype)) {
            ifxtype = 5;
        } else if (!conn.isUSVER() && ifxtype == 17 && !conn.isXPSVER8_50()) {
            ifxtype = 2;
        }
        return ifxtype & 0xFF;
    }

    private static void setClassInformationExtendedId(IfxColumnInfo info) {
        block0 : switch (info.ExtendedId) {
            case 5: {
                info.ifxTypeClassName = BOOLEAN_CLASS_NAME;
                info.ifxRealType = 45;
                break;
            }
            case 1: {
                info.ifxTypeClassName = LVARCHAR_CLASS_NAME;
                info.ifxRealType = 43;
                break;
            }
            case 10: {
                info.ifxTypeClassName = "IfxSmBlob";
                info.ifxRealType = 44;
                break;
            }
            case 11: {
                info.ifxTypeClassName = "IfxSmBlob";
                info.ifxRealType = 44;
                break;
            }
            case 25: {
                info.ifxTypeClassName = JSON_CLASS_NAME;
                info.ifxRealType = 44;
                break;
            }
            case 26: {
                info.ifxTypeClassName = "IfxUDT";
                info.ifxRealType = 44;
                break;
            }
            case 40: 
            case 41: {
                switch (info.SQLtype) {
                    case 19: 
                    case 20: 
                    case 21: {
                        info.ifxTypeClassName = IfxValue.IfxTypeToObject_9x(info.SQLtype);
                        info.ifxRealType = info.SQLtype;
                        break block0;
                    }
                }
                info.ifxTypeClassName = "IfxUDT";
                info.ifxRealType = 44;
                break;
            }
            default: {
                info.ifxTypeClassName = IfxValue.IfxTypeToObject_9x(info.SQLtype);
                info.ifxRealType = info.SQLtype;
            }
        }
    }

    public static void setClassInfo(IfxConnection conn, IfxColumnInfo info) {
        if (info.IsDistinct) {
            info.ifxTypeClassName = DISTINCT_CLASS_NAME;
            info.ifxRealType = info.SQLtype;
        } else if (info.ExtendedId == 0) {
            int ifxType = IfxValue.getRealIfxType(conn, info.SQLtype);
            String className = null;
            className = IfxValue.IfxTypeToObject_9x(ifxType);
            if (ifxType == 14) {
                byte startCode = (byte)(info.ColLength >> 4 & 0xF);
                className = startCode == 0 || startCode == 2 ? className + "YM" : className + "DF";
            }
            info.ifxTypeClassName = className;
            info.ifxRealType = ifxType;
        } else {
            IfxValue.setClassInformationExtendedId(info);
        }
    }

    static String getIfxTypeName(IfxConnection conn, IfxColumnInfo colinfo) throws SQLException {
        if (colinfo == null) {
            throw IfxErrMsg.getSQLException(-79714, conn);
        }
        if (colinfo.ifxTypeClassName == null) {
            if (!(colinfo.SQLtype != 52 && colinfo.SQLtype != 53 || conn.isBigintSupported())) {
                throw IfxErrMsg.getSQLException(-79882, ": IfxValue.makeInstance", conn);
            }
            if (conn.isDirect()) {
                int ifxtype = IfxValue.getRealIfxType(conn, colinfo.SQLtype);
                String className = null;
                if (ifxtype >= 17) {
                    if (colinfo.ExtendedId == 5 || colinfo.SourceType == 5) {
                        className = BOOLEAN_CLASS_NAME;
                        ifxtype = 45;
                    } else if (colinfo.ExtendedId == 1 || colinfo.SourceType == 1) {
                        className = LVARCHAR_CLASS_NAME;
                        ifxtype = 43;
                    }
                    if (colinfo.ExtendedId != 0 && (ifxtype == 40 || ifxtype == 41)) {
                        className = "IfxUDT";
                        ifxtype = 44;
                    }
                    if (className == null) {
                        className = IfxValue.IfxTypeToObject_9x(ifxtype);
                    }
                } else {
                    className = IfxTypeToObjectTable.get(ifxtype);
                }
                if (ifxtype == 14) {
                    byte startCode = (byte)(colinfo.ColLength >> 4 & 0xF);
                    className = startCode == 0 || startCode == 2 ? className + "YM" : className + "DF";
                }
                colinfo.ifxTypeClassName = className;
                colinfo.ifxRealType = ifxtype;
            } else {
                IfxValue.setClassInfo(conn, colinfo);
            }
        }
        return colinfo.ifxTypeClassName;
    }

    public static IfxObject makeInstance(IfxConnection conn, IfxColumnInfo colinfo) throws SQLException {
        return IfxValue.makeInstance(conn, colinfo, (Calendar)null);
    }

    static IfxObject makeInstance(IfxConnection conn, IfxColumnInfo colinfo, Calendar cal) throws SQLException {
        String className = null;
        String IntervalSubtype = null;
        className = IfxValue.getIfxTypeName(conn, colinfo);
        if (className == null) {
            throw IfxErrMsg.getSQLException(-79714, conn);
        }
        IfxObject obj = IfxValue.createInstanceFromClassName(className, IntervalSubtype);
        obj.setIfxType(colinfo.ifxRealType);
        obj.setExtendedTypeName(colinfo.ExtendedName);
        obj.setExtendedOwner(colinfo.ExtendedOwner);
        obj.setExtendedId(colinfo.ExtendedId);
        obj.setSourceType(colinfo.SourceType);
        obj.setEncodedLength(colinfo.ColLength);
        obj.setConnection(conn);
        if (obj instanceof IfxSmBlob) {
            ((IfxSmBlob)obj).setTableName(colinfo.TableName);
            ((IfxSmBlob)obj).setColumnName(colinfo.ColName);
        }
        if (cal != null && obj instanceof IfxDateTime) {
            ((IfxDateTime)obj).dbCalendar = cal;
        }
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, IfxColumnInfo colinfo, int sqlType) throws SQLException {
        return IfxValue.makeInstance(conn, null, colinfo, -1, sqlType);
    }

    private static IfxObject createInstanceFromClassName(String className, String IntervalSubType) throws SQLException {
        if (className == null) {
            throw IfxErrMsg.getSQLException(-79728);
        }
        try {
            Class<?> clsRef = IntervalSubType == null ? Class.forName("com.informix.jdbc." + className) : Class.forName("com.informix.jdbc." + className + IntervalSubType);
            return (IfxObject)clsRef.newInstance();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(e, -79716);
        }
    }

    static IfxObject makeInstance(IfxConnection conn, Object x, IfxColumnInfo colinfo) throws SQLException {
        return IfxValue.makeInstance(conn, x, (String)null, colinfo);
    }

    static IfxObject makeInstance(IfxConnection conn, Object x, String name, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        if (x == null && colinfo != null) {
            obj = IfxValue.makeInstance(conn, colinfo);
        } else if (x instanceof SQLData) {
            obj = IfxValue.makeInstance(conn, (SQLData)x, colinfo);
        } else if (x instanceof Clob) {
            obj = IfxValue.makeInstance(conn, (Clob)x, colinfo);
        } else if (x instanceof Blob) {
            obj = IfxValue.makeInstance(conn, (Blob)x, colinfo);
        } else if (x instanceof Struct) {
            obj = IfxValue.makeInstance(conn, (Struct)x, colinfo);
        } else if (x instanceof Array) {
            obj = IfxValue.makeInstance(conn, (Array)x, name, colinfo);
        } else if (x instanceof Collection) {
            obj = IfxValue.makeInstance(conn, (Collection)x, name, colinfo);
        } else {
            Class<?> cls = x.getClass();
            String clsName = cls.getName();
            if (colinfo != null) {
                if (clsName.equals("java.lang.Boolean")) {
                    obj = IfxValue.makeInstance(conn, (Boolean)x, colinfo);
                } else if (clsName.equals("[B")) {
                    obj = IfxValue.makeInstance(conn, (byte[])x, colinfo);
                } else if (cls.isArray()) {
                    obj = IfxValue.makeInstanceFromArray(conn, x, name);
                }
            }
            if (obj == null) {
                if (colinfo == null || colinfo.ExtendedId != 0) {
                    String tmpstr = null;
                    if (x instanceof IntervalYM) {
                        tmpstr = "YM";
                    } else if (x instanceof IntervalDF) {
                        tmpstr = "DF";
                    }
                    int type = IfxTypes.FromJavaToIfxType(clsName);
                    if (type == 49) {
                        throw IfxErrMsg.getSQLException(-79728, conn);
                    }
                    if (conn.isUSVER() && type == 0) {
                        type = colinfo != null && colinfo.ExtendedId == 10 ? 102 : (colinfo != null && colinfo.ExtendedId == 11 ? 101 : 43);
                    }
                    obj = IfxValue.makeInstanceFromIfxType(conn, type, tmpstr);
                    obj.fromObject(x);
                } else {
                    obj = x instanceof IntervalYM ? IfxValue.makeInstanceFromIfxType(conn, 14, "YM") : (x instanceof IntervalDF ? IfxValue.makeInstanceFromIfxType(conn, 14, "DF") : IfxValue.makeInstance(conn, colinfo));
                    obj.fromObject(x);
                }
            }
        }
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Object x, IfxColumnInfo colinfo, int sqltype) throws SQLException {
        return IfxValue.makeInstance(conn, x, colinfo, -1, sqltype);
    }

    static IfxObject makeInstance(IfxConnection conn, Object x, IfxColumnInfo colinfo, int scale, int sqltype) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && sqltype == -1 && colinfo.ExtendedId != 0 && colinfo.ExtendedId != 11 ? IfxValue.makeInstanceFromIfxType(conn, 43) : (colinfo != null ? IfxValue.makeInstance(conn, colinfo) : IfxValue.makeInstanceFromIfxType(conn, IfxTypes.FromJDBCToIfxType(sqltype)));
        if (scale == -1) {
            obj.fromObject(x);
        } else {
            obj.fromObject(x, scale);
        }
        return obj;
    }

    static IfxObject makeInstanceFromIfxType(IfxConnection conn, int ifxtype) throws SQLException {
        return IfxValue.makeInstanceFromIfxType(conn, ifxtype, null);
    }

    static IfxObject makeInstanceFromIfxType(IfxConnection conn, int ifxtype, String IntervalSubType) throws SQLException {
        IfxObject obj = (ifxtype = IfxValue.getRealIfxType(conn, ifxtype)) >= 17 && conn.isUSVER() ? IfxValue.createInstanceFromClassName(IfxValue.IfxTypeToObject_9x(ifxtype), null) : IfxValue.createInstanceFromClassName(IfxTypeToObjectTable.get(ifxtype), IntervalSubType);
        if (ifxtype == 101 || ifxtype == 102) {
            obj.setExtendedTypeName(IfxTypes.IfxTypeToName(ifxtype));
            if (!conn.isDirect()) {
                ifxtype = 44;
            }
        }
        obj.setIfxType(ifxtype);
        obj.setConnection(conn);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, BigDecimal x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 && colinfo.SQLtype != 14 && colinfo.SQLtype != 7 && colinfo.SQLtype != 10 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 5);
        obj.fromDecimal(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, boolean x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype != 14 && colinfo.SQLtype != 7 && colinfo.SQLtype != 10 ? IfxValue.makeInstance(conn, colinfo) : IfxValue.makeInstanceFromIfxType(conn, 1);
        obj.fromBoolean(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, short x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 && colinfo.SQLtype != 14 && colinfo.SQLtype != 7 && colinfo.SQLtype != 10 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 1);
        obj.fromShort(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, byte x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 && colinfo.SQLtype != 7 && colinfo.SQLtype != 10 && colinfo.SQLtype != 14 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 1);
        obj.fromByte(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, int x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 && colinfo.SQLtype != 14 && colinfo.SQLtype != 7 && colinfo.SQLtype != 10 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 2);
        obj.fromInt(x);
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IfxObject makeInstance(IfxConnection conn, long x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        if (colinfo == null) {
            obj = IfxValue.makeInstanceFromIfxType(conn, conn.isUSVER() ? 17 : 2);
        } else if (colinfo.SQLtype < 17 && colinfo.SQLtype != 14 && colinfo.SQLtype != 7 && colinfo.SQLtype != 10) {
            obj = IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype);
        } else if (colinfo.SQLtype == 52 || colinfo.SQLtype == 53) {
            if (!conn.isBigintSupported()) throw IfxErrMsg.getSQLException(-79882, ": IfxValue.makeInstance", conn);
            obj = IfxValue.makeInstanceFromIfxType(conn, 52);
        } else {
            obj = IfxValue.makeInstanceFromIfxType(conn, conn.isUSVER() ? 17 : 2);
        }
        obj.fromLong(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, float x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 && colinfo.SQLtype != 14 && colinfo.SQLtype != 7 && colinfo.SQLtype != 10 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 4);
        obj.fromFloat(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, double x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 && colinfo.SQLtype != 14 && colinfo.SQLtype != 7 && colinfo.SQLtype != 10 ? (colinfo.SQLtype == 8 || colinfo.SQLtype == 3 || colinfo.SQLtype == 5 || colinfo.SQLtype == 2 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 0)) : IfxValue.makeInstanceFromIfxType(conn, 3);
        obj.fromDouble(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, String x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj;
        if (!conn.isDirect() && colinfo != null) {
            String IntervalSubtype = null;
            if (colinfo.SQLtype == 46) {
                obj = IfxValue.makeInstanceFromIfxType(conn, 46);
            } else if (colinfo.SQLtype == 13 || colinfo.SQLtype == 16) {
                obj = IfxValue.makeInstanceFromIfxType(conn, 13);
            } else if (colinfo.SQLtype > 18) {
                if (colinfo.ExtendedId == 11) {
                    obj = IfxValue.makeInstanceFromIfxType(conn, 101);
                    obj.extendedID = 11;
                    if (obj instanceof IfxSmBlob) {
                        ((IfxSmBlob)obj).setTableName(colinfo.TableName);
                        ((IfxSmBlob)obj).setColumnName(colinfo.ColName);
                    }
                } else if (colinfo.ExtendedId == 5) {
                    obj = IfxValue.makeInstanceFromIfxType(conn, 0);
                } else {
                    obj = IfxValue.makeInstanceFromIfxType(conn, 43);
                    obj.extendedID = 1;
                    if (colinfo.IsDistinct) {
                        colinfo.ExtendedOwner = "informix";
                        obj.extendedName = "lvarchar";
                    }
                }
            } else {
                if (colinfo.SQLtype == 14) {
                    byte startCode = (byte)(colinfo.ColLength >> 4 & 0xF);
                    IntervalSubtype = startCode == 0 || startCode == 2 ? "YM" : "DF";
                }
                obj = IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype, IntervalSubtype);
            }
            if (colinfo.SQLtype == 13 || colinfo.SQLtype == 16) {
                obj.fromString(x, false);
            } else {
                if (colinfo.SQLtype == 14) {
                    obj.setEncodedLength(colinfo.ColLength);
                }
                obj.fromString(x);
            }
        } else {
            obj = IfxValue.makeInstanceFromIfxType(conn, 0);
            obj.fromString(x);
        }
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, byte[] x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = colinfo != null && colinfo.SQLtype != 1 && colinfo.SQLtype != 2 && colinfo.SQLtype != 3 && colinfo.SQLtype != 4 && colinfo.SQLtype != 5 && colinfo.SQLtype != 6 && colinfo.SQLtype != 8 && colinfo.SQLtype != 17 && colinfo.SQLtype != 18 && colinfo.SQLtype != 7 && colinfo.SQLtype != 10 && colinfo.SQLtype != 14 ? IfxValue.makeInstance(conn, colinfo) : (conn.isDirect() ? IfxValue.makeInstanceFromIfxType(conn, 102) : IfxValue.makeInstanceFromIfxType(conn, 11));
        obj.fromBytes(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Date x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 && colinfo.SQLtype != 1 && colinfo.SQLtype != 2 && colinfo.SQLtype != 3 && colinfo.SQLtype != 4 && colinfo.SQLtype != 5 && colinfo.SQLtype != 6 && colinfo.SQLtype != 8 && colinfo.SQLtype != 17 && colinfo.SQLtype != 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 7);
        obj.fromDate(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Time x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = colinfo != null && colinfo.SQLtype <= 18 && colinfo.SQLtype != 1 && colinfo.SQLtype != 2 && colinfo.SQLtype != 3 && colinfo.SQLtype != 4 && colinfo.SQLtype != 5 && colinfo.SQLtype != 6 && colinfo.SQLtype != 8 && colinfo.SQLtype != 17 && colinfo.SQLtype != 7 && colinfo.SQLtype != 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 10);
        obj.fromTime(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Timestamp x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = colinfo != null && colinfo.SQLtype <= 18 && colinfo.SQLtype != 1 && colinfo.SQLtype != 2 && colinfo.SQLtype != 3 && colinfo.SQLtype != 4 && colinfo.SQLtype != 5 && colinfo.SQLtype != 6 && colinfo.SQLtype != 8 && colinfo.SQLtype != 17 && colinfo.SQLtype != 7 && colinfo.SQLtype != 18 ? IfxValue.makeInstanceFromIfxType(conn, colinfo.SQLtype) : IfxValue.makeInstanceFromIfxType(conn, 10);
        obj.fromTimestamp(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, InputStream x, int length, IfxColumnInfo colinfo) throws SQLException {
        InputStream y = x instanceof IfxLobInputStream ? ((IfxLobInputStream)x).getStream() : x;
        IfxObject obj = colinfo != null ? IfxValue.makeInstance(conn, colinfo) : (conn.isDirect() ? IfxValue.makeInstanceFromIfxType(conn, 102) : IfxValue.makeInstanceFromIfxType(conn, 11));
        obj.fromInputStream(y, length);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, InputStream x, long length, IfxColumnInfo colinfo) throws SQLException {
        InputStream y = x instanceof IfxLobInputStream ? ((IfxLobInputStream)x).getStream() : x;
        IfxObject obj = colinfo != null ? IfxValue.makeInstance(conn, colinfo) : (conn.isDirect() ? IfxValue.makeInstanceFromIfxType(conn, 102) : IfxValue.makeInstanceFromIfxType(conn, 11));
        obj.fromInputStream(y, length);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Reader x, int length, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = IfxValue.makeInstance(conn, colinfo);
        obj.fromCharacterStream(x, length);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Reader x, long length, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = IfxValue.makeInstance(conn, colinfo);
        obj.fromCharacterStream(x, length);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, IntervalYM x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = IfxValue.makeInstanceFromIfxType(conn, 14, "YM");
        obj.fromIntervalYM(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, IntervalDF x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        obj = IfxValue.makeInstanceFromIfxType(conn, 14, "DF");
        obj.fromIntervalDF(x);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Clob clob, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = colinfo != null ? IfxValue.makeInstance(conn, colinfo) : (conn.isDirect() ? IfxValue.makeInstanceFromIfxType(conn, 101) : IfxValue.makeInstanceFromIfxType(conn, 12));
        obj.fromClob(clob);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Blob blob, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = colinfo != null ? IfxValue.makeInstance(conn, colinfo) : (conn.isDirect() ? IfxValue.makeInstanceFromIfxType(conn, 102) : IfxValue.makeInstanceFromIfxType(conn, 11));
        obj.fromBlob(blob);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, SQLData x, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = null;
        IfxUDTInfo typeinfo = null;
        String typename = x.getSQLTypeName();
        if (typename != null) {
            typeinfo = conn.getUDTInfo(colinfo, typename);
        }
        if (typeinfo == null) {
            throw IfxErrMsg.getSQLException(-79770, conn);
        }
        obj = IfxValue.createInstanceByTypeInfo(conn, typeinfo);
        if (obj != null) {
            obj.fromObject(x);
        }
        return obj;
    }

    private static IfxObject createInstanceByTypeInfo(IfxConnection conn, IfxUDTInfo typeinfo) throws SQLException {
        IfxObject obj = null;
        try {
            switch (typeinfo.JDBCtype) {
                case 2000: {
                    obj = new IfxUDT();
                    if (!conn.isDirect()) {
                        obj.setIfxType(44);
                        break;
                    }
                    obj.setIfxType(typeinfo.SQLtype);
                    break;
                }
                case 2001: {
                    obj = new IfxDistinct();
                    obj.setIfxType(typeinfo.SQLtype);
                    obj.isDistinct = true;
                    break;
                }
                case 2002: {
                    obj = new IfxRow();
                    obj.setIfxType(44);
                    obj.isNamedRow = true;
                }
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), conn);
        }
        if (obj != null) {
            obj.setExtendedTypeName(typeinfo.name);
            obj.setExtendedOwner(typeinfo.owner);
            obj.setExtendedId(typeinfo.xid);
            obj.setSourceType(typeinfo.source);
            obj.setConnection(conn);
        }
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IfxObject makeInstance(IfxConnection conn, IfxColumnInfo colinfo, int sqlType, String name) throws SQLException {
        IfxObject obj = null;
        if (colinfo != null) {
            return IfxValue.makeInstance(conn, colinfo);
        }
        int ifxType = IfxTypes.FromJDBCToIfxType(sqlType);
        if (ifxType <= 18) return IfxValue.makeInstanceFromIfxType(conn, ifxType);
        if (ifxType == 101) return IfxValue.makeInstanceFromIfxType(conn, ifxType);
        if (ifxType == 102) {
            return IfxValue.makeInstanceFromIfxType(conn, ifxType);
        }
        IfxUDTInfo typeinfo = null;
        if (name == null) return obj;
        if (sqlType != 2003) {
            typeinfo = conn.getUDTInfo(colinfo, name);
            if (typeinfo != null) return IfxValue.createInstanceByTypeInfo(conn, typeinfo);
            if (ifxType != 22) throw IfxErrMsg.getSQLException(-79770, conn);
            obj = IfxValue.makeInstanceFromIfxType(conn, ifxType);
            obj.setExtendedTypeName(name);
            return obj;
        } else {
            obj = IfxValue.makeInstanceFromIfxType(conn, ifxType);
            obj.setExtendedTypeName(name);
        }
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Array array, String name, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = IfxValue.makeInstanceFromIfxType(conn, 19);
        if (name == null) {
            obj.fromObject(array);
        } else {
            ((IfxCollection)obj).fromObject((Object)array, name);
        }
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Struct struct, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = IfxValue.makeInstanceFromIfxType(conn, 22);
        obj.fromObject(struct);
        return obj;
    }

    static IfxObject makeInstance(IfxConnection conn, Collection<?> coll, String name, IfxColumnInfo colinfo) throws SQLException {
        IfxObject obj = IfxValue.makeInstanceFromIfxType(conn, 19);
        if (name == null) {
            obj.fromObject(coll);
        } else {
            ((IfxCollection)obj).fromObject(coll, name);
        }
        if (coll.isEmpty() && colinfo != null && IfxTypes.isCollection(colinfo.SQLtype)) {
            obj.setExtendedTypeName(colinfo.ExtendedName);
        }
        return obj;
    }

    private static IfxObject makeInstanceFromArray(IfxConnection conn, Object x, String name) throws SQLException {
        IfxObject obj = IfxValue.makeInstanceFromIfxType(conn, 19);
        if (name == null) {
            obj.fromObject(x);
        } else {
            ((IfxCollection)obj).fromObject(x, name);
        }
        return obj;
    }

    static {
        IfxTypeToObjectTable.put(0, "IfxChar");
        IfxTypeToObjectTable.put(1, "IfxShort");
        IfxTypeToObjectTable.put(2, "IfxInteger");
        IfxTypeToObjectTable.put(3, "IfxFloat");
        IfxTypeToObjectTable.put(4, "IfxSmallFloat");
        IfxTypeToObjectTable.put(5, "IfxDecimal");
        IfxTypeToObjectTable.put(6, "IfxInteger");
        IfxTypeToObjectTable.put(8, "IfxDecimal");
        IfxTypeToObjectTable.put(7, "IfxDate");
        IfxTypeToObjectTable.put(10, "IfxDateTime");
        IfxTypeToObjectTable.put(8, "IfxDecimal");
        IfxTypeToObjectTable.put(11, "IfxBlob");
        IfxTypeToObjectTable.put(12, "IfxBlob");
        IfxTypeToObjectTable.put(13, "IfxVarChar");
        IfxTypeToObjectTable.put(14, "IfxInterval");
        IfxTypeToObjectTable.put(15, "IfxChar");
        IfxTypeToObjectTable.put(16, "IfxVarChar");
        IfxTypeToObjectTable.put(17, "IfxInt8");
        IfxTypeToObjectTable.put(18, "IfxInt8");
        IfxTypeToObjectTable.put(19, "IfxCollection");
        IfxTypeToObjectTable.put(20, "IfxCollection");
        IfxTypeToObjectTable.put(21, "IfxCollection");
        IfxTypeToObjectTable.put(22, "IfxRow");
        IfxTypeToObjectTable.put(40, "IfxUDT");
        IfxTypeToObjectTable.put(41, "IfxUDT");
        IfxTypeToObjectTable.put(43, LVARCHAR_CLASS_NAME);
        IfxTypeToObjectTable.put(45, BOOLEAN_CLASS_NAME);
        IfxTypeToObjectTable.put(44, "IfxUDT");
        IfxTypeToObjectTable.put(101, "IfxSmBlob");
        IfxTypeToObjectTable.put(102, "IfxSmBlob");
        IfxTypeToObjectTable.put(46, IMPEXP_CLASS_NAME);
        IfxTypeToObjectTable.put(52, "IfxBigInt");
        IfxTypeToObjectTable.put(53, "IfxBigInt");
    }
}

