/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import java.util.List;
import java.util.Map;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.RelevanceQuery;
import shaded.com.google.common.collect.ImmutableMap;

abstract class MultiFieldQuery<T extends QueryBuilder>
extends RelevanceQuery<T> {
    public MultiFieldQuery(Map<String, RelevanceQuery.QueryBuilderStep<T>> queryBuildActions) {
        super(queryBuildActions);
    }

    @Override
    public T createQueryBuilder(List<NamedArgumentExpression> arguments2) {
        NamedArgumentExpression fields2 = arguments2.stream().filter(a -> a.getArgName().equalsIgnoreCase("fields")).findFirst().orElseThrow(() -> new SemanticCheckException("'fields' parameter is missing."));
        NamedArgumentExpression query = arguments2.stream().filter(a -> a.getArgName().equalsIgnoreCase("query")).findFirst().orElseThrow(() -> new SemanticCheckException("'query' parameter is missing"));
        ImmutableMap<String, Float> fieldsAndWeights = fields2.getValue().valueOf().tupleValue().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> ((ExprValue)e.getValue()).floatValue()));
        return this.createBuilder(fieldsAndWeights, query.getValue().valueOf().stringValue());
    }

    protected abstract T createBuilder(ImmutableMap<String, Float> var1, String var2);
}

