/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.plugin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.legacy.executor.format.ErrorMessageFactory;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.node.NodeClient;
import shaded.com.google.common.collect.ImmutableList;

public class RestSqlStatsAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestSqlStatsAction.class);
    public static final String STATS_API_ENDPOINT = "/_plugins/_sql/stats";

    public RestSqlStatsAction(Settings settings, RestController restController) {
    }

    public String getName() {
        return "sql_stats_action";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of(new RestHandler.Route(RestRequest.Method.POST, STATS_API_ENDPOINT), new RestHandler.Route(RestRequest.Method.GET, STATS_API_ENDPOINT));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        QueryContext.addRequestId();
        try {
            return channel -> this.schedule(client, () -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, Metrics.getInstance().collectToJSON())));
        }
        catch (Exception e) {
            LOG.error("Failed during Query SQL STATS Action.", (Throwable)e);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, ErrorMessageFactory.createErrorMessage(e, RestStatus.INTERNAL_SERVER_ERROR.getStatus()).toString()));
        }
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("sql", "flat", "separator", "_score", "_type", "_id", "newLine", "format", "sanitize"));
        return responseParams;
    }

    private void schedule(NodeClient client, Runnable task) {
        ThreadPool threadPool = client.threadPool();
        threadPool.schedule(this.withCurrentContext(task), new TimeValue(0L), "sql-worker");
    }

    private Runnable withCurrentContext(Runnable task) {
        Map currentContext = ThreadContext.getImmutableContext();
        return () -> {
            ThreadContext.putAll((Map)currentContext);
            task.run();
        };
    }
}

