/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opensearch.sql.legacy.cursor.Cursor;
import org.opensearch.sql.legacy.cursor.NullCursor;
import org.opensearch.sql.legacy.domain.ColumnTypeProvider;
import org.opensearch.sql.legacy.domain.Delete;
import org.opensearch.sql.legacy.domain.IndexStatement;
import org.opensearch.sql.legacy.domain.Query;
import org.opensearch.sql.legacy.domain.QueryStatement;
import org.opensearch.sql.legacy.executor.adapter.QueryPlanQueryAction;
import org.opensearch.sql.legacy.executor.adapter.QueryPlanRequestBuilder;
import org.opensearch.sql.legacy.executor.format.BindingTupleResultSet;
import org.opensearch.sql.legacy.executor.format.DataRows;
import org.opensearch.sql.legacy.executor.format.DeleteResultSet;
import org.opensearch.sql.legacy.executor.format.DescribeResultSet;
import org.opensearch.sql.legacy.executor.format.ErrorMessage;
import org.opensearch.sql.legacy.executor.format.ErrorMessageFactory;
import org.opensearch.sql.legacy.executor.format.ResultSet;
import org.opensearch.sql.legacy.executor.format.Schema;
import org.opensearch.sql.legacy.executor.format.SelectResultSet;
import org.opensearch.sql.legacy.executor.format.ShowResultSet;
import org.opensearch.sql.legacy.query.DefaultQueryAction;
import org.opensearch.sql.legacy.query.QueryAction;
import org.opensearch.sql.legacy.query.planner.core.ColumnNode;
import org.opensearch.transport.client.Client;
import shaded.com.google.common.base.Strings;

public class Protocol {
    static final int OK_STATUS = 200;
    static final int ERROR_STATUS = 500;
    private final String formatType;
    private final int status;
    private long size;
    private long total;
    private ResultSet resultSet;
    private ErrorMessage error;
    private List<ColumnNode> columnNodeList;
    private Cursor cursor = new NullCursor();
    private ColumnTypeProvider scriptColumnType = new ColumnTypeProvider();

    public Protocol(Client client, QueryAction queryAction, Object queryResult, String formatType, Cursor cursor) {
        this.cursor = cursor;
        if (queryAction instanceof QueryPlanQueryAction) {
            this.columnNodeList = ((QueryPlanRequestBuilder)((QueryPlanQueryAction)queryAction).explain()).outputColumns();
        } else if (queryAction instanceof DefaultQueryAction) {
            this.scriptColumnType = queryAction.getScriptColumnType();
        }
        this.formatType = formatType;
        QueryStatement query = queryAction.getQueryStatement();
        this.status = 200;
        this.resultSet = this.loadResultSet(client, query, queryResult);
        this.size = this.resultSet.getDataRows().getSize();
        this.total = this.resultSet.getDataRows().getTotalHits();
    }

    public Protocol(Client client, Object queryResult, String formatType, Cursor cursor) {
        this.cursor = cursor;
        this.status = 200;
        this.formatType = formatType;
        this.resultSet = this.loadResultSetForCursor(client, queryResult);
    }

    public Protocol(Exception e) {
        this.formatType = null;
        this.status = 500;
        this.error = ErrorMessageFactory.createErrorMessage(e, this.status);
    }

    private ResultSet loadResultSetForCursor(Client client, Object queryResult) {
        return new SelectResultSet(client, queryResult, this.formatType, this.cursor);
    }

    private ResultSet loadResultSet(Client client, QueryStatement queryStatement, Object queryResult) {
        if (queryResult instanceof List) {
            return new BindingTupleResultSet(this.columnNodeList, (List)queryResult);
        }
        if (queryStatement instanceof Delete) {
            return new DeleteResultSet(client, (Delete)queryStatement, queryResult);
        }
        if (queryStatement instanceof Query) {
            return new SelectResultSet(client, (Query)queryStatement, queryResult, this.scriptColumnType, this.formatType, this.cursor);
        }
        if (queryStatement instanceof IndexStatement) {
            IndexStatement statement = (IndexStatement)queryStatement;
            IndexStatement.StatementType statementType = statement.getStatementType();
            if (statementType == IndexStatement.StatementType.SHOW) {
                return new ShowResultSet(client, statement, queryResult);
            }
            if (statementType == IndexStatement.StatementType.DESCRIBE) {
                return new DescribeResultSet(client, statement, queryResult);
            }
        }
        throw new UnsupportedOperationException(String.format("The following instance of QueryStatement is not supported: %s", queryStatement.getClass().toString()));
    }

    public int getStatus() {
        return this.status;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public String format() {
        if (this.status == 200) {
            switch (this.formatType) {
                case "jdbc": {
                    return this.outputInJdbcFormat();
                }
                case "table": {
                    return this.outputInTableFormat();
                }
                case "raw": {
                    return this.outputInRawFormat();
                }
            }
            throw new UnsupportedOperationException(String.format("The following format is not supported: %s", this.formatType));
        }
        return this.error.toString();
    }

    private String outputInJdbcFormat() {
        JSONObject formattedOutput = new JSONObject();
        formattedOutput.put("status", this.status);
        formattedOutput.put("size", this.size);
        formattedOutput.put("total", this.total);
        JSONArray schema = this.getSchemaAsJson();
        formattedOutput.put("schema", schema);
        formattedOutput.put("datarows", this.getDataRowsAsJson());
        String cursorId = this.cursor.generateCursorId();
        if (!Strings.isNullOrEmpty(cursorId)) {
            formattedOutput.put("cursor", cursorId);
        }
        return formattedOutput.toString(2);
    }

    private String outputInRawFormat() {
        Schema schema = this.resultSet.getSchema();
        DataRows dataRows = this.resultSet.getDataRows();
        StringBuilder formattedOutput = new StringBuilder();
        for (DataRows.Row row : dataRows) {
            formattedOutput.append(this.rawEntry(row, schema)).append("\n");
        }
        return formattedOutput.toString();
    }

    private String outputInTableFormat() {
        return null;
    }

    public String cursorFormat() {
        if (this.status == 200) {
            switch (this.formatType) {
                case "jdbc": {
                    return this.cursorOutputInJDBCFormat();
                }
            }
            throw new UnsupportedOperationException(String.format("The following response format is not supported for cursor: [%s]", this.formatType));
        }
        return this.error.toString();
    }

    private String cursorOutputInJDBCFormat() {
        JSONObject formattedOutput = new JSONObject();
        formattedOutput.put("datarows", this.getDataRowsAsJson());
        String cursorId = this.cursor.generateCursorId();
        if (!Strings.isNullOrEmpty(cursorId)) {
            formattedOutput.put("cursor", cursorId);
        }
        return formattedOutput.toString(2);
    }

    private String rawEntry(DataRows.Row row, Schema schema) {
        return StreamSupport.stream(schema.spliterator(), false).map(column -> row.getDataOrDefault(column.getName(), "NULL").toString()).collect(Collectors.joining("|"));
    }

    private JSONArray getSchemaAsJson() {
        Schema schema = this.resultSet.getSchema();
        JSONArray schemaJson = new JSONArray();
        for (Schema.Column column : schema) {
            schemaJson.put(this.schemaEntry(column.getName(), column.getAlias(), column.getType()));
        }
        return schemaJson;
    }

    private JSONObject schemaEntry(String name, String alias, String type2) {
        JSONObject entry = new JSONObject();
        entry.put("name", name);
        if (alias != null) {
            entry.put("alias", alias);
        }
        entry.put("type", type2);
        return entry;
    }

    private JSONArray getDataRowsAsJson() {
        Schema schema = this.resultSet.getSchema();
        DataRows dataRows = this.resultSet.getDataRows();
        JSONArray dataRowsJson = new JSONArray();
        for (DataRows.Row row : dataRows) {
            dataRowsJson.put(this.dataEntry(row, schema));
        }
        return dataRowsJson;
    }

    private JSONArray dataEntry(DataRows.Row dataRow, Schema schema) {
        JSONArray entry = new JSONArray();
        for (Schema.Column column : schema) {
            String columnName = column.getIdentifier();
            entry.put(dataRow.getDataOrDefault(columnName, JSONObject.NULL));
        }
        return entry;
    }
}

