/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class TimestampDiffFunction
extends ImplementorUDF {
    public TimestampDiffFunction() {
        super(new DiffImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.BIGINT_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)((Object)OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME).or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.DATETIME)).or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.DATETIME, SqlTypeFamily.STRING)).or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING))));
    }

    public static class DiffImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            int startIndex = 1;
            int endIndex = 2;
            ExprType startType = OpenSearchTypeFactory.convertRelDataTypeToExprType(call.getOperands().get(startIndex).getType());
            ExprType endType = OpenSearchTypeFactory.convertRelDataTypeToExprType(call.getOperands().get(endIndex).getType());
            MethodCallExpression functionProperties = Expressions.call(UserDefinedFunctionUtils.class, "restoreFunctionProperties", new Expression[]{translator.getRoot()});
            NewExpression unit = Expressions.new_(ExprStringValue.class, new Expression[]{translatedOperands.getFirst()});
            MethodCallExpression start = Expressions.call(ExprValueUtils.class, "fromObjectValue", new Expression[]{translatedOperands.get(startIndex), Expressions.constant(startType)});
            MethodCallExpression end = Expressions.call(ExprValueUtils.class, "fromObjectValue", new Expression[]{translatedOperands.get(endIndex), Expressions.constant(endType)});
            if (ExprCoreType.TIME.equals(startType) || ExprCoreType.TIME.equals(endType)) {
                return Expressions.call(DiffImplementor.class, "diffForTime", new Expression[]{functionProperties, unit, start, end});
            }
            return Expressions.call(DiffImplementor.class, "diff", new Expression[]{unit, start, end});
        }

        public static long diff(ExprStringValue unit, ExprValue start, ExprValue end) {
            ExprValue diffResult = DateTimeFunctions.exprTimestampDiff(unit, start, end);
            return diffResult.longValue();
        }

        public static long diffForTime(FunctionProperties functionProperties, ExprStringValue unit, ExprValue start, ExprValue end) {
            return DateTimeFunctions.exprTimestampDiffForTimeType(functionProperties, unit, start, end).longValue();
        }
    }
}

