/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeConversionUtils;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import org.opensearch.sql.utils.DateTimeUtils;

public class AddSubDateFunction
extends ImplementorUDF {
    public AddSubDateFunction(boolean isAdd) {
        super(new AddSubDateImplementor(isAdd), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return opBinding -> {
            RelDataType temporalType = opBinding.getOperandType(0);
            RelDataType temporalDeltaType = opBinding.getOperandType(1);
            if (OpenSearchTypeFactory.convertRelDataTypeToExprType(temporalType) == ExprCoreType.DATE && SqlTypeFamily.NUMERIC.contains(temporalDeltaType)) {
                return UserDefinedFunctionUtils.NULLABLE_DATE_UDT;
            }
            return UserDefinedFunctionUtils.NULLABLE_TIMESTAMP_UDT;
        };
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)((Object)OperandTypes.DATETIME_INTERVAL.or(OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.INTEGER)).or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.DATETIME_INTERVAL)).or(OperandTypes.STRING_INTEGER)));
    }

    public static class AddSubDateImplementor
    implements NotNullImplementor {
        private final boolean isAdd;

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression temporal = translatedOperands.get(0);
            Expression temporalDelta = translatedOperands.get(1);
            RelDataType temporalType = call.getOperands().get(0).getType();
            RelDataType temporalDeltaType = call.getOperands().get(1).getType();
            MethodCallExpression base = Expressions.call(ExprValueUtils.class, "fromObjectValue", new Expression[]{temporal, Expressions.constant(OpenSearchTypeFactory.convertRelDataTypeToExprType(temporalType))});
            MethodCallExpression properties2 = Expressions.call(UserDefinedFunctionUtils.class, "restoreFunctionProperties", new Expression[]{translator.getRoot()});
            if (SqlTypeFamily.NUMERIC.contains(temporalDeltaType)) {
                String applyDaysFuncName = ExprCoreType.DATE.equals(OpenSearchTypeFactory.convertRelDataTypeToExprType(temporalType)) ? (this.isAdd ? "dateAddDaysOnDate" : "dateSubDaysOnDate") : (this.isAdd ? "dateAddDaysOnTimestamp" : "dateSubDaysOnTimestamp");
                return Expressions.call(AddSubDateImplementor.class, applyDaysFuncName, new Expression[]{properties2, base, Expressions.convert_(temporalDelta, Long.TYPE)});
            }
            if (SqlTypeFamily.DATETIME_INTERVAL.contains(temporalDeltaType)) {
                MethodCallExpression interval = Expressions.call(DateTimeConversionUtils.class, "convertToTemporalAmount", new Expression[]{Expressions.convert_(temporalDelta, Long.TYPE), Expressions.constant((Object)Objects.requireNonNull(temporalDeltaType.getIntervalQualifier()).getUnit())});
                String applyIntervalFuncName = this.isAdd ? "dateAddInterval" : "dateSubInterval";
                return Expressions.call(AddSubDateImplementor.class, applyIntervalFuncName, new Expression[]{properties2, base, interval});
            }
            throw new IllegalArgumentException(String.format("The second argument of %s function must be a number or an interval", this.isAdd ? "date_add" : "date_sub"));
        }

        public static String dateAddDaysOnDate(FunctionProperties ignored, ExprValue datetime, long days) {
            return (String)new ExprDateValue(datetime.dateValue().plusDays(days)).valueForCalcite();
        }

        public static String dateSubDaysOnDate(FunctionProperties ignored, ExprValue datetime, long days) {
            return (String)new ExprDateValue(datetime.dateValue().minusDays(days)).valueForCalcite();
        }

        public static String dateAddDaysOnTimestamp(FunctionProperties properties2, ExprValue datetime, long days) {
            LocalDateTime dt = DateTimeUtils.extractTimestamp(datetime, properties2).atZone(ZoneOffset.UTC).toLocalDateTime();
            return (String)new ExprTimestampValue(dt.plusDays(days)).valueForCalcite();
        }

        public static String dateSubDaysOnTimestamp(FunctionProperties properties2, ExprValue datetime, long days) {
            LocalDateTime dt = DateTimeUtils.extractTimestamp(datetime, properties2).atZone(ZoneOffset.UTC).toLocalDateTime();
            return (String)new ExprTimestampValue(dt.minusDays(days)).valueForCalcite();
        }

        public static String dateAddInterval(FunctionProperties properties2, ExprValue datetime, TemporalAmount interval) {
            LocalDateTime dt = DateTimeUtils.extractTimestamp(datetime, properties2).atZone(ZoneOffset.UTC).toLocalDateTime();
            return (String)new ExprTimestampValue(dt.plus(interval)).valueForCalcite();
        }

        public static String dateSubInterval(FunctionProperties properties2, ExprValue datetime, TemporalAmount interval) {
            LocalDateTime dt = DateTimeUtils.extractTimestamp(datetime, properties2).atZone(ZoneOffset.UTC).toLocalDateTime();
            return (String)new ExprTimestampValue(dt.minus(interval)).valueForCalcite();
        }

        @Generated
        public AddSubDateImplementor(boolean isAdd) {
            this.isAdd = isAdd;
        }
    }
}

