/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.utils.DateTimeFormatters;

public class ExprTimestampValue
extends AbstractExprValue {
    private final Instant timestamp;

    public ExprTimestampValue(String timestamp) {
        try {
            this.timestamp = LocalDateTime.parse(timestamp, DateTimeFormatters.DATE_TIME_FORMATTER_VARIABLE_NANOS).atZone(ZoneOffset.UTC).toInstant();
        }
        catch (DateTimeParseException e) {
            throw new SemanticCheckException(String.format("timestamp:%s in unsupported format, please use 'yyyy-MM-dd HH:mm:ss[.SSSSSSSSS]'", timestamp));
        }
    }

    public ExprTimestampValue(LocalDateTime localDateTime) {
        this.timestamp = localDateTime.atZone(ZoneOffset.UTC).toInstant();
    }

    @Override
    public String value() {
        return this.timestamp.getNano() == 0 ? DateTimeFormatters.DATE_TIME_FORMATTER_WITHOUT_NANO.withZone(ZoneOffset.UTC).format(this.timestamp.truncatedTo(ChronoUnit.SECONDS)) : DateTimeFormatters.DATE_TIME_FORMATTER_VARIABLE_NANOS.withZone(ZoneOffset.UTC).format(this.timestamp);
    }

    @Override
    public ExprType type() {
        return ExprCoreType.TIMESTAMP;
    }

    @Override
    public Instant timestampValue() {
        return this.timestamp;
    }

    @Override
    public LocalDate dateValue() {
        return this.timestamp.atZone(ZoneOffset.UTC).toLocalDate();
    }

    @Override
    public LocalTime timeValue() {
        return this.timestamp.atZone(ZoneOffset.UTC).toLocalTime();
    }

    @Override
    public boolean isDateTime() {
        return true;
    }

    public String toString() {
        return String.format("TIMESTAMP '%s'", this.value());
    }

    @Override
    public int compare(ExprValue other) {
        return this.timestamp.compareTo(other.timestampValue().atZone(ZoneOffset.UTC).toInstant());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.timestamp.equals(other.timestampValue().atZone(ZoneOffset.UTC).toInstant());
    }

    public int hashCode() {
        return Objects.hashCode(this.timestamp);
    }

    @Generated
    public ExprTimestampValue(Instant timestamp) {
        this.timestamp = timestamp;
    }
}

