/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.apache.hc.core5.concurrent.CancellableDependency;

public class Cancellable
implements org.apache.hc.core5.concurrent.Cancellable {
    static final Cancellable NO_OP = new Cancellable(null){

        @Override
        public boolean cancel() {
            throw new UnsupportedOperationException();
        }

        @Override
        void runIfNotCancelled(Runnable runnable2) {
            throw new UnsupportedOperationException();
        }
    };
    private final CancellableDependency httpRequest;

    static Cancellable fromRequest(CancellableDependency httpRequest) {
        return new Cancellable(httpRequest);
    }

    private Cancellable(CancellableDependency httpRequest) {
        this.httpRequest = httpRequest;
    }

    @Override
    public synchronized boolean cancel() {
        return this.httpRequest.cancel();
    }

    synchronized void runIfNotCancelled(Runnable runnable2) {
        if (this.httpRequest.isCancelled()) {
            throw Cancellable.newCancellationException();
        }
        runnable2.run();
    }

    synchronized <T> T callIfNotCancelled(Callable<T> callable) throws IOException {
        if (this.httpRequest.isCancelled()) {
            throw Cancellable.newCancellationException();
        }
        try {
            return callable.call();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    static CancellationException newCancellationException() {
        return new CancellationException("request was cancelled");
    }
}

