/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

final class Ed448PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private final Ed448 ed448 = new Ed448(){

        @Override
        protected Xof createXof() {
            return (Xof)Register.createDigest(FipsSHS.Algorithm.SHAKE256);
        }
    };
    private final byte[] data = new byte[57];
    private Ed448PublicKeyParameters cachedPublicKey;

    public Ed448PrivateKeyParameters(SecureRandom secureRandom) {
        super(true);
        Ed448.generatePrivateKey(secureRandom, this.data);
    }

    public Ed448PrivateKeyParameters(byte[] byArray) {
        this(Ed448PrivateKeyParameters.validate(byArray), 0);
    }

    public Ed448PrivateKeyParameters(byte[] byArray, int n) {
        super(true);
        System.arraycopy(byArray, n, this.data, 0, 57);
    }

    public Ed448PrivateKeyParameters(InputStream inputStream2) throws IOException {
        super(true);
        if (57 != Streams.readFully(inputStream2, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed448 private key");
        }
    }

    public void encode(byte[] byArray, int n) {
        System.arraycopy(this.data, 0, byArray, n, 57);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ed448PublicKeyParameters generatePublicKey() {
        byte[] byArray = this.data;
        synchronized (this.data) {
            if (null == this.cachedPublicKey) {
                byte[] byArray2 = new byte[57];
                this.ed448.generatePublicKey(this.data, 0, byArray2, 0);
                this.cachedPublicKey = new Ed448PublicKeyParameters(byArray2, 0);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.cachedPublicKey;
        }
    }

    public void sign(int n, Ed448PublicKeyParameters ed448PublicKeyParameters, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        this.sign(n, byArray, byArray2, n2, n3, byArray3, n4);
    }

    public void sign(int n, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        Ed448PublicKeyParameters ed448PublicKeyParameters = this.generatePublicKey();
        byte[] byArray4 = new byte[57];
        ed448PublicKeyParameters.encode(byArray4, 0);
        switch (n) {
            case 0: {
                this.ed448.sign(this.data, 0, byArray4, 0, byArray, byArray2, n2, n3, byArray3, n4);
                break;
            }
            case 1: {
                if (64 != n3) {
                    throw new IllegalArgumentException("msgLen");
                }
                this.ed448.signPrehash(this.data, 0, byArray4, 0, byArray, byArray2, n2, byArray3, n4);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm");
            }
        }
    }

    private static byte[] validate(byte[] byArray) {
        if (byArray.length != 57) {
            throw new IllegalArgumentException("'buf' must have length 57");
        }
        return byArray;
    }
}

