/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.sql.type.SqlTypeName;
import shaded.com.google.common.collect.ImmutableSet;

public interface SqlTypeMappingRule {
    public Map<SqlTypeName, ImmutableSet<SqlTypeName>> getTypeMapping();

    default public boolean canApplyFrom(SqlTypeName to, SqlTypeName from) {
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(from, "from");
        if (to == SqlTypeName.NULL || to == SqlTypeName.UNKNOWN) {
            return false;
        }
        if (from == SqlTypeName.NULL || from == SqlTypeName.UNKNOWN) {
            return true;
        }
        Set rule = this.getTypeMapping().get((Object)to);
        if (rule == null) {
            throw new AssertionError((Object)("No assign rules for " + (Object)((Object)to) + " defined"));
        }
        return rule.contains((Object)from);
    }
}

